/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server;

import at.mrdevelopment.esl.admin.platform.config.storage.PlatformStorage;
import at.mrdevelopment.esl.custom.ServerStartupSettings;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.DatasetRegistry;
import at.mrdevelopment.esl.persistence.maintenance.ESLDatabaseConfiguration;
import at.mrdevelopment.esl.server.ESLServerInterface;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.http.WebserviceException;
import at.mrdevelopment.toolkit.info.Info;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.io.File;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;

public abstract class ESLServer
implements ESLServerInterface {
    protected final Info info = Info.load(ESLServer.class);
    protected final DatasetRegistry datasetRegistry = new DatasetRegistry();
    protected final ServerStartupSettings serverStartupSettings;
    protected final ClassLoader classLoader;
    protected final PlatformStorage platformStorage;
    protected final ESLDatabaseConfiguration configuration;

    public ESLServer(File databaseConfigFile, ServerStartupSettings serverStartupSettings, ClassLoader classLoader, PlatformStorage platformStorage) throws InitializationException, SerializeException, DatasetException {
        this.configuration = this.initConfiguration(databaseConfigFile, classLoader);
        if (serverStartupSettings.geDatabaseMaintenanceOptions().isPurge()) {
            this.configuration.purgeTables();
        }
        this.serverStartupSettings = serverStartupSettings;
        this.classLoader = classLoader;
        this.platformStorage = platformStorage;
    }

    private ESLDatabaseConfiguration initConfiguration(File configFile, ClassLoader classLoader) throws InitializationException {
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            ESLDatabaseConfiguration configuration = new ESLDatabaseConfiguration();
            configuration.configure(configFile);
            this.addRecordTypes(configuration);
            return configuration;
        }
        catch (Throwable exc) {
            throw new InitializationException(exc);
        }
    }

    public SessionFactory initSessionFactory() throws InitializationException {
        try {
            return this.configuration.buildSessionFactory();
        }
        catch (Throwable exc) {
            throw new InitializationException(exc);
        }
    }

    protected abstract void addRecordTypes(Configuration var1);

    public abstract void start(int var1, boolean var2) throws InitializationException, WebserviceException;

    public Version getVersion() {
        return this.info.getVersion();
    }
}

