/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server;

import at.mrdevelopment.esl.admin.AccessPointConfigurationXMLSerializer;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.BroadcastMessage;
import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.core.accesspoint.AccessPointType;
import at.mrdevelopment.esl.core.accesspoint.AccessPointTypeMapping;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.AccessPointConfigurationDataset;
import at.mrdevelopment.esl.persistence.dataset.AccessPointInfoDataset;
import at.mrdevelopment.esl.persistence.record.AccessPointInfo;
import at.mrdevelopment.esl.processing.BroadcastProcessor;
import at.mrdevelopment.esl.server.AutoConfigurationAccessPointServiceCache;
import at.mrdevelopment.esl.server.DiscoveredAccessPointsHolder;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class AutoConfigurationBroadcastProcessor
implements BroadcastProcessor {
    private static ESLLogger logger = ESLLogger.getLogger(AutoConfigurationBroadcastProcessor.class);
    private final Version version;
    private final DiscoveredAccessPointsHolder discoveredAPs;
    private final AccessPointConfigurationXMLSerializer accessPointConfigurationXMLSerializer;
    private final AutoConfigurationAccessPointServiceCache accessPointClientCache;

    public AutoConfigurationBroadcastProcessor(Version version, AccessPointConfigurationDataset accessPointConfigurationDataset, AccessPointInfoDataset accessPointInfoDataset, DiscoveredAccessPointsHolder discoveredImagoAPs) throws InitializationException {
        this.version = version;
        this.discoveredAPs = discoveredImagoAPs;
        this.accessPointConfigurationXMLSerializer = new AccessPointConfigurationXMLSerializer();
        this.accessPointClientCache = new AutoConfigurationAccessPointServiceCache(accessPointInfoDataset);
    }

    public void processBroadcast(String broadcastMessageString, String accessPointAddress) throws UnsupportedEncodingException, SerializeException, DatasetException, InitializationException {
        logger.debug("Received access point discovery broadcast message from %s: %s", new Object[]{accessPointAddress, broadcastMessageString});
        BroadcastMessage broadcastMessage = this.accessPointConfigurationXMLSerializer.parseBroadcastMessageXML((InputStream)new ByteArrayInputStream(broadcastMessageString.getBytes("UTF-8")));
        int accessPointId = broadcastMessage.getAccessPointId();
        logger.info("Received access point discovery broadcast from access point %d at %s", new Object[]{accessPointId, accessPointAddress});
        if (!this.isValidVersionForAutoConfig(broadcastMessage.getVersion())) {
            logger.warn("Version of access point %d not compatible with this servers auto configuration", new Object[]{accessPointId});
            return;
        }
        ServiceAddress broadcastServiceAddress = new ServiceAddress(broadcastMessage.isSsl(), accessPointAddress, broadcastMessage.getPort(), "admin", Config.getAccessPointAdministrationPassword());
        this.updateAccessPointInfo(accessPointId, broadcastServiceAddress, broadcastMessage.getVersion(), broadcastMessage.isAutoConfig());
    }

    private void updateAccessPointInfo(int accessPointId, ServiceAddress serviceAddress, Version version, boolean autoConfig) throws InitializationException {
        AccessPointInfo accessPointInfo = AccessPointInfo.createDiscovered((int)accessPointId, (ServiceAddress)serviceAddress, (ServiceAddress)serviceAddress, (Version)version, (Boolean)autoConfig);
        this.discoveredAPs.addDiscoveredAccessPointInfo(accessPointInfo);
        if (AccessPointTypeMapping.getType((int)accessPointId) == AccessPointType.IMAGOTAG) {
            this.accessPointClientCache.updateAccessPointInfo(accessPointInfo, serviceAddress);
        }
    }

    private boolean isValidVersionForAutoConfig(Version accessPointVersion) {
        return accessPointVersion.getMainRelease() <= this.version.getMainRelease();
    }

    public void shutdown() {
        this.accessPointClientCache.shutdown();
    }
}

