/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server;

import at.mrdevelopment.esl.accesspoint.AccessPointReplyCallback;
import at.mrdevelopment.esl.accesspoint.AccessPointService;
import at.mrdevelopment.esl.accesspoint.AccessPointServiceStatus;
import at.mrdevelopment.esl.accesspoint.AccessPointWorkload;
import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.core.DefaultPeriodicTasksExecutor;
import at.mrdevelopment.esl.core.ESLProcessingTask;
import at.mrdevelopment.esl.core.JoinRequest;
import at.mrdevelopment.esl.core.LabelEvent;
import at.mrdevelopment.esl.core.LabelEventListener;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.WakeupListener;
import at.mrdevelopment.esl.core.WakeupNotifier;
import at.mrdevelopment.esl.licencing.FeatureUnlock;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.AccessPointConfigurationDataset;
import at.mrdevelopment.esl.persistence.dataset.AccessPointInfoDataset;
import at.mrdevelopment.esl.persistence.dataset.LabelInfoDataset;
import at.mrdevelopment.esl.persistence.dataset.LabelInfoHistoryDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.dataset.TransactionSupplier;
import at.mrdevelopment.esl.roaming.RoamingTableBuilder;
import at.mrdevelopment.esl.roaming.RoamingTableType;
import at.mrdevelopment.esl.server.ESLAccessPointProcessingTask;
import at.mrdevelopment.esl.server.MultipleWakeupStatistic;
import at.mrdevelopment.esl.server.SendRoamingTableTask;
import at.mrdevelopment.esl.tasks.TaskType;
import at.mrdevelopment.esl.type.WakeupStatistic;
import at.mrdevelopment.esl.updatetask.ExternalUpdateTask;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.toolkit.ConversionUtils;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.http.WebserviceException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.joda.time.DateTime;

public class AccessPointCommunication
extends DefaultPeriodicTasksExecutor
implements AccessPointReplyCallback {
    static ESLLogger logger = ESLLogger.getLogger(AccessPointCommunication.class);
    private final TransactionSupplier transactionSupplier;
    private final AccessPointInfoDataset accessPointInfoDataset;
    private final LabelInfoDataset labelInfoDataset;
    private final WakeupNotifier wakeupNotifier;
    private final LabelEventListener labelEventListener;
    private final FeatureUnlock featureUnlock;
    private final RoamingTableBuilder roamingTableBuilder;
    private final Map<LabelId, MultipleWakeupStatistic> wakeupStatistics = new HashMap<LabelId, MultipleWakeupStatistic>();
    private final Object accessPointWorkloadLock = new Object();
    private final Map<Integer, AccessPointWorkload> untransmittedMergedWorkloads = new HashMap<Integer, AccessPointWorkload>();
    private final Map<Integer, AccessPointWorkload> currentWorkloads = new HashMap<Integer, AccessPointWorkload>();
    private DateTime lastAssignmentTime = DateTime.now();
    private Map<Integer, HashMap<UUID, ExternalUpdateTask>> receivedUpdateTasks = new HashMap<Integer, HashMap<UUID, ExternalUpdateTask>>();

    public AccessPointCommunication(TransactionSupplier transactionSupplier, AccessPointConfigurationDataset accessPointConfigurationDataset, AccessPointInfoDataset accessPointInfoDataset, LabelInfoDataset labelInfoDataset, WakeupNotifier wakeupNotifier, LabelEventListener labelEventListener, FeatureUnlock featureUnlock, LabelInfoHistoryDataset labelInfoHistoryDataset) throws InitializationException, DatasetException {
        super(false);
        this.transactionSupplier = transactionSupplier;
        this.accessPointInfoDataset = accessPointInfoDataset;
        this.labelInfoDataset = labelInfoDataset;
        this.wakeupNotifier = wakeupNotifier;
        this.labelEventListener = labelEventListener;
        this.featureUnlock = featureUnlock;
        this.roamingTableBuilder = this.newRoamingTableBuilder(labelInfoDataset, labelInfoHistoryDataset);
        wakeupNotifier.registerWakeupListener((WakeupListener)labelInfoDataset);
        wakeupNotifier.registerWakeupListener((WakeupListener)this.roamingTableBuilder);
        labelInfoDataset.registerLabelRegisterListener(this.roamingTableBuilder);
        Transaction transaction = transactionSupplier.newTransaction();
        try {
            accessPointConfigurationDataset.registerAccessPointListener(this.roamingTableBuilder, transaction);
            transaction.commit();
        }
        catch (Exception exc) {
            transaction.rollback();
            throw new InitializationException((Throwable)exc);
        }
        this.createProcessingTasks();
    }

    private RoamingTableBuilder newRoamingTableBuilder(LabelInfoDataset labelInfoDataset, LabelInfoHistoryDataset labelInfoHistoryDataset) throws DatasetException {
        RoamingTableType roamingTableType = RoamingTableType.fromString(Config.getRoamingTableStrategy());
        logger.info("Using %s roaming table", new Object[]{roamingTableType.getName()});
        return roamingTableType.createRoamingTableBuilder(this.transactionSupplier, this.featureUnlock, labelInfoDataset, labelInfoHistoryDataset);
    }

    private void createProcessingTasks() throws InitializationException {
        this.addProcessingTask(new ESLAccessPointProcessingTask("Status query", this.accessPointInfoDataset){

            @Override
            public void runForAccessPoint(AccessPointService accessPointService) throws DatasetException, SerializeException {
                AccessPointCommunication.this.queryAccessPointStatus(accessPointService);
            }
        });
        this.addProcessingTask(new ESLAccessPointProcessingTask("Query", this.accessPointInfoDataset.getOnlineAndLicensedAccessPointManager()){

            @Override
            public void runForAccessPoint(AccessPointService accessPointService) throws DatasetException, SerializeException {
                AccessPointCommunication.this.queryAccessPoint(accessPointService);
            }
        });
        this.addProcessingTask(new SendRoamingTableTask(this.accessPointInfoDataset.getOnlineAndLicensedAccessPointManager(), this.roamingTableBuilder));
        this.addProcessingTask(new ESLAccessPointProcessingTask("Submitting workload", this.accessPointInfoDataset.getOnlineAndLicensedAccessPointManager()){

            @Override
            public void runForAccessPoint(AccessPointService accessPointService) throws WebserviceException, SerializeException {
                AccessPointCommunication.this.submitCurrentWorkloadsForTransmission();
            }
        });
        this.addProcessingTask(new ESLAccessPointProcessingTask("Processing workload", this.accessPointInfoDataset.getOnlineAndLicensedAccessPointManager()){

            @Override
            public void runForAccessPoint(AccessPointService accessPointService) throws WebserviceException, SerializeException {
                AccessPointCommunication.this.processWorkloadsFromQueue(accessPointService);
            }
        });
        this.addProcessingTask(new ESLProcessingTask(){

            public void run() throws Exception {
                AccessPointCommunication.this.accessPointInfoDataset.createAccessPointServices();
            }
        });
    }

    private void queryAccessPointStatus(AccessPointService accessPointService) throws DatasetException, SerializeException {
        logger.info("Query service status of access point %s", new Object[]{accessPointService.getServiceAddress()});
        accessPointService.queryServiceStatus((AccessPointReplyCallback)this);
    }

    private void queryAccessPoint(AccessPointService accessPointService) throws DatasetException, SerializeException {
        logger.info("Query assigned labels of access point %s", new Object[]{accessPointService.getServiceAddress()});
        accessPointService.queryAssignedLabels((AccessPointReplyCallback)this);
        logger.info("Query discovered labels of access point %s", new Object[]{accessPointService.getServiceAddress()});
        accessPointService.queryDiscoveredLabels((AccessPointReplyCallback)this);
        logger.info("Query update tasks of access point %s", new Object[]{accessPointService.getServiceAddress()});
        accessPointService.queryUpdateTasks((AccessPointReplyCallback)this);
        logger.info("Query label events of access point %s", new Object[]{accessPointService.getServiceAddress()});
        accessPointService.queryLabelEvents((AccessPointReplyCallback)this);
    }

    private void processWorkloadsFromQueue(AccessPointService accessPointService) throws WebserviceException, SerializeException {
        logger.info("Sending open workloads to access point %s", new Object[]{accessPointService.getServiceAddress()});
        int accessPointId = accessPointService.getAccessPointId();
        AccessPointWorkload workload = this.getUntransmittedMergedWorkload(accessPointId);
        if (workload != null) {
            List tasksToAbort = workload.getTasksToAbort();
            List tasksToRemove = workload.getTasksToRemove();
            List scheduledTasks = workload.getScheduledUpdateTasks();
            logger.info("Sending abort requests for %d tasks", new Object[]{tasksToAbort.size()});
            accessPointService.sendAbortRequests(tasksToAbort);
            logger.info("Sending remove requests for %d tasks", new Object[]{tasksToRemove.size()});
            accessPointService.sendRemoveRequests(tasksToRemove);
            logger.info("Sending %d scheduled tasks", new Object[]{scheduledTasks.size()});
            if (scheduledTasks.size() > 0) {
                this.lastAssignmentTime = DateTime.now();
                accessPointService.sendTasks(scheduledTasks);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AccessPointWorkload getUntransmittedMergedWorkload(int accessPointId) {
        Object object = this.accessPointWorkloadLock;
        synchronized (object) {
            return this.untransmittedMergedWorkloads.remove(accessPointId);
        }
    }

    public DateTime getLastAssignmentTime() {
        return this.lastAssignmentTime;
    }

    public int getAssignedAccessPoint(LabelId labelId) {
        return this.roamingTableBuilder.getAssignedAccessPoint(labelId);
    }

    public boolean canPreassignUpdate(int accessPointId) {
        return this.accessPointInfoDataset.isOnline(accessPointId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canAssignUpdate(int accessPointId, TaskPriority taskPriority) {
        if (this.accessPointInfoDataset.isOnline(accessPointId)) {
            double priorityMultiplier = taskPriority.isHigh() ? 1.0 : 0.75;
            AccessPointServiceStatus serviceStatus = this.accessPointInfoDataset.getServiceStatus(accessPointId);
            int totalScheduledUpdateTaskCount = 0;
            int totalScheduledUpdateTaskSize = 0;
            Object object = this.accessPointWorkloadLock;
            synchronized (object) {
                AccessPointWorkload currentWorkload;
                AccessPointWorkload untransmittedMergedWorkload = this.untransmittedMergedWorkloads.get(accessPointId);
                if (untransmittedMergedWorkload != null) {
                    totalScheduledUpdateTaskCount += untransmittedMergedWorkload.getScheduledUpdateTaskCount();
                    totalScheduledUpdateTaskSize += untransmittedMergedWorkload.getScheduledUpdateTaskSize();
                }
                if ((currentWorkload = this.currentWorkloads.get(accessPointId)) != null) {
                    totalScheduledUpdateTaskCount += currentWorkload.getScheduledUpdateTaskCount();
                    totalScheduledUpdateTaskSize += currentWorkload.getScheduledUpdateTaskSize();
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Current scheduled tasks: %d tasks (%s)", new Object[]{totalScheduledUpdateTaskCount, ConversionUtils.toHumanReadableBytes((long)totalScheduledUpdateTaskSize)});
                logger.debug("Current access point %d tasks from service status: %d tasks (%s)", new Object[]{accessPointId, serviceStatus.getTasksCount(), ConversionUtils.toHumanReadableBytes((long)serviceStatus.getTasksSize())});
            }
            return totalScheduledUpdateTaskCount < Config.getAccessPointMaxSendTasksCount() && totalScheduledUpdateTaskSize < Config.getAccessPointMaxSendTasksSize() && (double)(serviceStatus.getTasksCount() + totalScheduledUpdateTaskCount) < (double)Config.getAccessPointMaxTotalTasksCount() * priorityMultiplier && (double)(serviceStatus.getTasksSize() + totalScheduledUpdateTaskSize) < (double)Config.getAccessPointMaxTotalTasksSize() * priorityMultiplier;
        }
        return false;
    }

    public boolean isTaskSupported(int accessPointId, TaskType taskType) {
        AccessPointService accessPointService = this.accessPointInfoDataset.getService(accessPointId);
        return accessPointService.isTaskTypeSupported(taskType);
    }

    public WakeupStatistic getWakeupStatistic(LabelId labelId, int accessPointId) {
        MultipleWakeupStatistic multipleWakeupStatistic = this.wakeupStatistics.get(labelId);
        WakeupStatistic wakeupStatistic = multipleWakeupStatistic != null ? multipleWakeupStatistic.getForAccessPoint(accessPointId) : new WakeupStatistic(labelId.toAddress(), accessPointId);
        return wakeupStatistic != null ? wakeupStatistic : new WakeupStatistic(labelId.toAddress(), accessPointId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, List<ExternalUpdateTask>> getUnprocessedReceivedUpdateTasks() {
        Map<Integer, HashMap<UUID, ExternalUpdateTask>> map = this.receivedUpdateTasks;
        synchronized (map) {
            HashMap<Integer, List<ExternalUpdateTask>> unprocessedTasks = new HashMap<Integer, List<ExternalUpdateTask>>();
            for (Map.Entry<Integer, HashMap<UUID, ExternalUpdateTask>> entry : this.receivedUpdateTasks.entrySet()) {
                int accessPointId = entry.getKey();
                HashMap<UUID, ExternalUpdateTask> tasks = entry.getValue();
                unprocessedTasks.put(accessPointId, new ArrayList<ExternalUpdateTask>(tasks.values()));
            }
            this.receivedUpdateTasks.clear();
            return unprocessedTasks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleTaskForAborting(int accessPointId, UUID taskId) {
        Object object = this.accessPointWorkloadLock;
        synchronized (object) {
            AccessPointWorkload accessPointWorkload = this.getCurrentAccessPointWorkload(accessPointId);
            accessPointWorkload.scheduleTaskForAborting(taskId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleTaskForRemoval(int accessPointId, UUID taskId) {
        Object object = this.accessPointWorkloadLock;
        synchronized (object) {
            AccessPointWorkload accessPointWorkload = this.getCurrentAccessPointWorkload(accessPointId);
            accessPointWorkload.scheduleTaskForRemoval(taskId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleUpdateTask(int accessPointId, ExternalUpdateTask updateTask) {
        Object object = this.accessPointWorkloadLock;
        synchronized (object) {
            AccessPointWorkload workload = this.getCurrentAccessPointWorkload(accessPointId);
            workload.scheduleUpdateTask(updateTask);
        }
    }

    private AccessPointWorkload getCurrentAccessPointWorkload(int accessPointId) {
        AccessPointWorkload accessPointWorkload = this.currentWorkloads.get(accessPointId);
        if (accessPointWorkload == null) {
            accessPointWorkload = new AccessPointWorkload();
            this.currentWorkloads.put(accessPointId, accessPointWorkload);
        }
        return accessPointWorkload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitCurrentWorkloadsForTransmission() {
        Object object = this.accessPointWorkloadLock;
        synchronized (object) {
            for (Map.Entry<Integer, AccessPointWorkload> entry : this.currentWorkloads.entrySet()) {
                int accessPointId = entry.getKey();
                AccessPointWorkload currentWorkload = entry.getValue();
                if (currentWorkload.isEmpty()) continue;
                logger.info("Current workload for access point %d: %d abort requests, %d remove requests, %d update tasks (%s)", new Object[]{accessPointId, currentWorkload.getScheduledAbortRequestCount(), currentWorkload.getScheduledRemoveRequestCount(), currentWorkload.getScheduledUpdateTaskCount(), ConversionUtils.toHumanReadableBytes((long)currentWorkload.getScheduledUpdateTaskSize())});
                AccessPointWorkload previousMergedWorkload = this.untransmittedMergedWorkloads.get(accessPointId);
                AccessPointWorkload mergedWorkload = null;
                mergedWorkload = previousMergedWorkload != null ? AccessPointWorkload.merge((AccessPointWorkload)previousMergedWorkload, (AccessPointWorkload)currentWorkload) : currentWorkload;
                this.untransmittedMergedWorkloads.put(accessPointId, mergedWorkload);
                logger.info("Merged workload for access point %d: %d abort requests, %d remove requests, %d update tasks (%s)", new Object[]{accessPointId, mergedWorkload.getScheduledAbortRequestCount(), mergedWorkload.getScheduledRemoveRequestCount(), mergedWorkload.getScheduledUpdateTaskCount(), ConversionUtils.toHumanReadableBytes((long)mergedWorkload.getScheduledUpdateTaskSize())});
            }
            this.currentWorkloads.clear();
        }
    }

    public void failedToQueryAccessPoint(AccessPointService accessPointService) {
        if (this.accessPointInfoDataset.isOnline(accessPointService.getAccessPointId())) {
            logger.warn("Failed to query access point %s - marking as OFFLINE", new Object[]{accessPointService.getServiceAddress()});
            this.accessPointInfoDataset.setAccessPointOffline(accessPointService.getAccessPointId());
        }
    }

    public void processServiceStatus(AccessPointService accessPointService, AccessPointServiceStatus serviceStatus) {
        this.accessPointInfoDataset.updateServiceStatus(serviceStatus);
        this.roamingTableBuilder.updateChannelTable(serviceStatus);
    }

    public void processWakeupStatistics(Collection<WakeupStatistic> receivedWakeupStatistics) {
        for (WakeupStatistic wakeupStatistic : receivedWakeupStatistics) {
            Address labelAddress = wakeupStatistic.getLabelAddress();
            LabelId labelId = new LabelId(labelAddress);
            if (this.labelInfoDataset.isRegistered(labelId)) {
                MultipleWakeupStatistic multipleWakeupStatistic = this.wakeupStatistics.get(labelId);
                if (multipleWakeupStatistic == null) {
                    multipleWakeupStatistic = new MultipleWakeupStatistic(labelAddress);
                    this.wakeupStatistics.put(labelId, multipleWakeupStatistic);
                }
                if (!multipleWakeupStatistic.addWakeupStatistic(wakeupStatistic)) continue;
                this.wakeupNotifier.notifyReceivedWakeup(wakeupStatistic);
                continue;
            }
            this.wakeupStatistics.remove(labelId);
        }
    }

    public void processJoinRequests(Collection<JoinRequest> joinRequests) {
        for (JoinRequest joinRequest : joinRequests) {
            Address labelAddress = joinRequest.getLabelAddress();
            LabelId labelId = new LabelId(labelAddress);
            if (!this.labelInfoDataset.isRegistered(labelId)) continue;
            this.wakeupNotifier.notifyReceivedJoinRequest(joinRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpdateTasks(int accessPointId, Collection<ExternalUpdateTask> newReceivedUpdateTasks) throws DatasetException {
        Map<Integer, HashMap<UUID, ExternalUpdateTask>> map = this.receivedUpdateTasks;
        synchronized (map) {
            HashMap<UUID, Object> receivedUpdateTasksForAccessPoint = this.receivedUpdateTasks.get(accessPointId);
            if (receivedUpdateTasksForAccessPoint == null) {
                receivedUpdateTasksForAccessPoint = new HashMap();
                this.receivedUpdateTasks.put(accessPointId, receivedUpdateTasksForAccessPoint);
            }
            for (ExternalUpdateTask updateTask : newReceivedUpdateTasks) {
                if (!updateTask.isFinished()) continue;
                receivedUpdateTasksForAccessPoint.put(updateTask.getTaskId(), updateTask);
            }
        }
    }

    public void processLabelEvents(int accessPointId, Collection<LabelEvent> labelEvents) {
        for (LabelEvent labelEvent : labelEvents) {
            this.labelEventListener.receivedLabelEvent(labelEvent);
        }
    }

    public boolean isFinished() {
        return false;
    }

    public long getReloadTime() {
        return (long)Config.getServerReloadSleepTimeInSeconds() * 1000L;
    }
}

