/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.roaming;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.licencing.FeatureUnlock;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.LabelInfoDataset;
import at.mrdevelopment.esl.persistence.dataset.LabelInfoHistoryDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.dataset.TransactionSupplier;
import at.mrdevelopment.esl.persistence.query.LastLabelInfoHistoryForLabelQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.persistence.record.LabelInfoHistoryRecord;
import at.mrdevelopment.esl.persistence.record.RegisteredLabel;
import at.mrdevelopment.esl.roaming.DefaultRoamingTableBuilder;
import at.mrdevelopment.esl.roaming.ManualRoamingTableBuilder;
import at.mrdevelopment.esl.roaming.ProductionRoamingTableBuilder;
import at.mrdevelopment.esl.roaming.RoamingEntry;
import at.mrdevelopment.esl.roaming.RoamingTableBuilder;
import at.mrdevelopment.esl.server.AccessPointCommunication;
import at.mrdevelopment.toolkit.log.ComputationTimeLogger;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public enum RoamingTableType {
    DEFAULT("default"){

        private Map<LabelId, RoamingEntry> buildInitialRoamingEntries(TransactionSupplier transactionSupplier, LabelInfoDataset labelInfoDataset, LabelInfoHistoryDataset labelInfoHistoryDataset) throws DatasetException {
            ESLLogger logger = ESLLogger.getLogger(AccessPointCommunication.class);
            logger.info("Restoring roaming table...");
            HashMap<LabelId, RoamingEntry> roamingEntries = new HashMap<LabelId, RoamingEntry>();
            ComputationTimeLogger timeLogger = new ComputationTimeLogger(logger);
            timeLogger.start();
            Transaction transaction = transactionSupplier.newTransaction();
            try {
                LastLabelInfoHistoryForLabelQuery labelInfoHistoryForLabelQuery = new LastLabelInfoHistoryForLabelQuery(labelInfoHistoryDataset);
                QueryResult result = labelInfoHistoryForLabelQuery.getResult(QueryRestriction.newUnpagedQuery(), transaction);
                Map<LabelId, RegisteredLabel> labelRegistrations = labelInfoDataset.getLabelRegistration();
                for (LabelInfoHistoryRecord record : result.getRecords()) {
                    RegisteredLabel labelRegistration = labelRegistrations.get(record.getLabelId());
                    if (labelRegistration == null) continue;
                    RoamingEntry roamingEntry = new RoamingEntry(labelRegistration.toLabelId(), labelRegistration.getPin());
                    roamingEntry.update(record.getAccessPointId(), record.getWakeupTime());
                    roamingEntries.put(labelRegistration.toLabelId(), roamingEntry);
                }
                transaction.commit();
            }
            catch (Exception exc) {
                transaction.rollback();
                throw new DatasetException((Throwable)exc);
            }
            timeLogger.logTimeInfo("Restoring roaming table took");
            logger.info("Created initial roaming table with %d entries", new Object[]{roamingEntries.size()});
            return roamingEntries;
        }

        @Override
        public RoamingTableBuilder createRoamingTableBuilder(TransactionSupplier transactionSupplier, FeatureUnlock featureUnlock, LabelInfoDataset labelInfoDataset, LabelInfoHistoryDataset labelInfoHistoryDataset) throws DatasetException {
            return new DefaultRoamingTableBuilder(featureUnlock, this.buildInitialRoamingEntries(transactionSupplier, labelInfoDataset, labelInfoHistoryDataset));
        }
    }
    ,
    MANUAL("manual"){

        @Override
        public RoamingTableBuilder createRoamingTableBuilder(TransactionSupplier transactionSupplier, FeatureUnlock featureUnlock, LabelInfoDataset labelInfoDataset, LabelInfoHistoryDataset labelInfoHistoryDataset) throws DatasetException {
            return new ManualRoamingTableBuilder(labelInfoDataset, featureUnlock);
        }
    }
    ,
    PRODUCTION("production"){

        @Override
        public RoamingTableBuilder createRoamingTableBuilder(TransactionSupplier transactionSupplier, FeatureUnlock featureUnlock, LabelInfoDataset labelInfoDataset, LabelInfoHistoryDataset labelInfoHistoryDataset) throws DatasetException {
            return new ProductionRoamingTableBuilder();
        }
    };

    private final String name;

    private RoamingTableType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract RoamingTableBuilder createRoamingTableBuilder(TransactionSupplier var1, FeatureUnlock var2, LabelInfoDataset var3, LabelInfoHistoryDataset var4) throws DatasetException;

    public static RoamingTableType fromString(String name) {
        for (RoamingTableType roamingTableType : RoamingTableType.values()) {
            if (!StringUtils.equalsIgnoreCase((String)roamingTableType.getName(), (String)name)) continue;
            return roamingTableType;
        }
        return DEFAULT;
    }
}

