/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.roaming;

import at.mrdevelopment.esl.accesspoint.AccessPointServiceStatus;
import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.core.JoinRequest;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.esl.core.security.Key;
import at.mrdevelopment.esl.core.security.Pin;
import at.mrdevelopment.esl.roaming.RoamingEntry;
import at.mrdevelopment.esl.roaming.RoamingTableBuilder;
import at.mrdevelopment.esl.roaming.ThinInternalRoamingTable;
import at.mrdevelopment.esl.type.WakeupStatistic;
import at.mrdevelopment.esl.wireless.ChannelTableEntry;
import at.mrdevelopment.esl.wireless.RoamingTable;
import at.mrdevelopment.esl.wireless.SyncProfile;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ProductionRoamingTableBuilder
implements RoamingTableBuilder {
    static ESLLogger logger = ESLLogger.getLogger(ProductionRoamingTableBuilder.class);
    private final Map<Integer, WirelessChannel> channelTable = new HashMap<Integer, WirelessChannel>();
    private final Map<LabelId, RoamingEntry> roamingEntries = new HashMap<LabelId, RoamingEntry>();

    public synchronized void receivedWakeup(WakeupStatistic wakeupStatistic) {
    }

    public synchronized void receivedJoinRequest(JoinRequest joinRequest) {
    }

    @Override
    public synchronized void registerLabel(LabelId labelId, Pin pin) {
    }

    @Override
    public synchronized void unregisterLabel(LabelId labelId) {
    }

    @Override
    public synchronized void addAccessPoint(int accessPointId, ServiceAddress serviceAddress, boolean isAutoConfig) {
        this.channelTable.put(accessPointId, null);
    }

    @Override
    public synchronized void removeAccessPoint(int accessPointId) {
        this.channelTable.remove(accessPointId);
    }

    @Override
    public synchronized boolean isModified() {
        return true;
    }

    @Override
    public synchronized void resetModified() {
    }

    @Override
    public synchronized void updateChannelTable(AccessPointServiceStatus serviceStatus) {
        int accessPointId = serviceStatus.getAccessPointId();
        WirelessChannel newChannel = serviceStatus.getChannel();
        if (newChannel == null) {
            return;
        }
        WirelessChannel oldChannel = this.channelTable.get(accessPointId);
        if (newChannel != oldChannel) {
            this.channelTable.put(accessPointId, newChannel);
        }
    }

    @Override
    public synchronized RoamingTable getRoamingTable(int accessPointId) {
        Set<ChannelTableEntry> channelTable = Collections.singleton(new ChannelTableEntry(accessPointId, this.channelTable.get(accessPointId)));
        ArrayList roamingAssignments = new ArrayList();
        int roamingTabelValidTimeInMinutes = Math.max(Config.getRoamingTableValidTimeInMinutes(), Config.getRoamingTableResendTimeInMinutes() + 5);
        int pingIntervalInMinutes = Config.getPingLabelsIntervalInMinutes();
        return new RoamingTable(0, roamingTabelValidTimeInMinutes, pingIntervalInMinutes, channelTable, roamingAssignments, true, false, true, Key.emptyKey(), SyncProfile.RETAIL_DEFAULT);
    }

    @Override
    public synchronized int getAssignedAccessPoint(LabelId labelId) {
        RoamingEntry roamingEntry = this.roamingEntries.get(labelId);
        return roamingEntry != null ? roamingEntry.getAccessPointId() : 0;
    }

    @Override
    public synchronized void printRoamingTable() {
        if (logger.isInfoEnabled()) {
            HashMap<Integer, Integer> assignedLabels = new HashMap<Integer, Integer>();
            int unassignedLabelsCount = 0;
            for (RoamingEntry roamingEntry : this.roamingEntries.values()) {
                int accessPointId = roamingEntry.getAccessPointId();
                if (accessPointId != 0) {
                    Integer count = (Integer)assignedLabels.get(accessPointId);
                    assignedLabels.put(accessPointId, count == null ? 1 : count + 1);
                    continue;
                }
                ++unassignedLabelsCount;
            }
            logger.info("Roaming Table: %d unassigned labels", new Object[]{unassignedLabelsCount});
            for (Map.Entry entry : assignedLabels.entrySet()) {
                logger.info("Roaming Table: Access point %d has %d assigned labels", new Object[]{entry.getKey(), entry.getValue()});
            }
        }
    }

    @Override
    public ThinInternalRoamingTable getThinInternalRoamingTable(int accessPointId) {
        return null;
    }

    @Override
    public boolean isThinRoamingTableSupported() {
        return false;
    }
}

