/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.roaming;

import at.mrdevelopment.esl.accesspoint.AccessPointServiceStatus;
import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.core.JoinRequest;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.LabelTagsLookup;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.esl.core.security.Key;
import at.mrdevelopment.esl.core.security.Pin;
import at.mrdevelopment.esl.licencing.FeatureUnlock;
import at.mrdevelopment.esl.roaming.RoamingEntry;
import at.mrdevelopment.esl.roaming.RoamingTableBuilder;
import at.mrdevelopment.esl.roaming.ThinInternalRoamingTable;
import at.mrdevelopment.esl.type.WakeupStatistic;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.esl.wireless.ChannelTableEntry;
import at.mrdevelopment.esl.wireless.RoamingAssignment;
import at.mrdevelopment.esl.wireless.RoamingTable;
import at.mrdevelopment.esl.wireless.SyncProfile;
import at.mrdevelopment.toolkit.log.ESLLogger;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;

public class ManualRoamingTableBuilder
implements RoamingTableBuilder {
    static ESLLogger logger = ESLLogger.getLogger(ManualRoamingTableBuilder.class);
    private final LabelTagsLookup labelTagsLookup;
    private final FeatureUnlock featureUnlock;
    private final Map<Integer, WirelessChannel> channelTable = new HashMap<Integer, WirelessChannel>();
    private final Map<LabelId, RoamingEntry> roamingEntries = new HashMap<LabelId, RoamingEntry>();

    public ManualRoamingTableBuilder(LabelTagsLookup labelTagsLookup, FeatureUnlock featureUnlock) {
        this.labelTagsLookup = labelTagsLookup;
        this.featureUnlock = featureUnlock;
    }

    public synchronized void receivedWakeup(WakeupStatistic wakeupStatistic) {
        Address labelAddress = wakeupStatistic.getLabelAddress();
        LabelId labelId = new LabelId(labelAddress);
        RoamingEntry roamingEntry = this.roamingEntries.get(labelId);
        if (roamingEntry != null && !wakeupStatistic.isKeyUnset()) {
            roamingEntry.removePin();
        }
    }

    public synchronized void receivedJoinRequest(JoinRequest joinRequest) {
    }

    @Override
    public synchronized void registerLabel(LabelId labelId, Pin pin) {
        RoamingEntry roamingEntryImpl = new RoamingEntry(labelId, pin);
        for (String tag : this.labelTagsLookup.getTagsForLabel(labelId)) {
            if (!tag.matches("AP\\d+")) continue;
            int accessPointId = Integer.parseInt(StringUtils.removeStart((String)tag, (String)"AP"));
            roamingEntryImpl.update(accessPointId, DateTime.now());
        }
        this.roamingEntries.put(labelId, roamingEntryImpl);
    }

    @Override
    public synchronized void unregisterLabel(LabelId labelId) {
        this.roamingEntries.remove(labelId);
    }

    @Override
    public synchronized void addAccessPoint(int accessPointId, ServiceAddress serviceAddress, boolean isAutoConfig) {
        this.channelTable.put(accessPointId, null);
    }

    @Override
    public synchronized void removeAccessPoint(int accessPointId) {
        this.channelTable.remove(accessPointId);
    }

    @Override
    public synchronized boolean isModified() {
        return true;
    }

    @Override
    public synchronized void resetModified() {
    }

    @Override
    public synchronized void updateChannelTable(AccessPointServiceStatus serviceStatus) {
        int accessPointId = serviceStatus.getAccessPointId();
        WirelessChannel newChannel = serviceStatus.getChannel();
        if (newChannel == null) {
            return;
        }
        WirelessChannel oldChannel = this.channelTable.get(accessPointId);
        if (newChannel != oldChannel) {
            this.channelTable.put(accessPointId, newChannel);
        }
    }

    @Override
    public synchronized RoamingTable getRoamingTable(int accessPointId) {
        ArrayList<ChannelTableEntry> accessPointEntries = new ArrayList<ChannelTableEntry>(this.channelTable.size());
        ArrayList<RoamingAssignment> roamingAssignments = new ArrayList<RoamingAssignment>();
        WirelessChannel wirelessChannel = this.channelTable.get(accessPointId);
        if (wirelessChannel != null) {
            ChannelTableEntry accessPointEntry = new ChannelTableEntry(accessPointId, wirelessChannel);
            accessPointEntries.add(accessPointEntry);
        }
        for (RoamingEntry roamingEntry : this.roamingEntries.values()) {
            if (accessPointId != roamingEntry.getAccessPointId()) continue;
            LabelId labelId = roamingEntry.getLabelId();
            Pin pin = roamingEntry.getPin();
            RoamingAssignment roamingAssignment = new RoamingAssignment(labelId.toAddress(), pin, labelId.getLabelType(), accessPointId);
            roamingAssignments.add(roamingAssignment);
        }
        int protocolId = this.featureUnlock.isUnrestrictedSyncAllowed() ? 0 : 1;
        int roamingTabelValidTimeInMinutes = Math.max(Config.getRoamingTableValidTimeInMinutes(), Config.getRoamingTableResendTimeInMinutes() + 5);
        int pingIntervalInMinutes = Config.getPingLabelsIntervalInMinutes();
        String passphrase = Config.getEncryptionPassphrase();
        boolean encryptionRequired = Config.isForceEncryption() ? true : !this.featureUnlock.isUnencryptedCommunicationAllowed();
        boolean allowBlacklistedLabels = this.featureUnlock.isLabelFromLegacyBlacklistAllowed();
        Key key = Strings.isNullOrEmpty((String)passphrase) ? null : Key.generateFromPassphrase((String)passphrase);
        SyncProfile syncProfile = SyncProfile.fromString((String)Config.getSyncProfile());
        return new RoamingTable(protocolId, roamingTabelValidTimeInMinutes, pingIntervalInMinutes, accessPointEntries, roamingAssignments, false, encryptionRequired, allowBlacklistedLabels, key, syncProfile);
    }

    @Override
    public synchronized int getAssignedAccessPoint(LabelId labelId) {
        RoamingEntry roamingEntry = this.roamingEntries.get(labelId);
        return roamingEntry != null ? roamingEntry.getAccessPointId() : 0;
    }

    @Override
    public synchronized void printRoamingTable() {
        if (logger.isInfoEnabled()) {
            HashMap<Integer, Integer> assignedLabels = new HashMap<Integer, Integer>();
            int unassignedLabelsCount = 0;
            for (RoamingEntry roamingEntry : this.roamingEntries.values()) {
                int accessPointId = roamingEntry.getAccessPointId();
                if (accessPointId != 0) {
                    Integer count = (Integer)assignedLabels.get(accessPointId);
                    assignedLabels.put(accessPointId, count == null ? 1 : count + 1);
                    continue;
                }
                ++unassignedLabelsCount;
            }
            logger.info("Roaming Table: %d unassigned labels", new Object[]{unassignedLabelsCount});
            for (Map.Entry entry : assignedLabels.entrySet()) {
                logger.info("Roaming Table: Access point %d has %d assigned labels", new Object[]{entry.getKey(), entry.getValue()});
            }
        }
    }

    @Override
    public ThinInternalRoamingTable getThinInternalRoamingTable(int accessPointId) {
        return null;
    }

    @Override
    public boolean isThinRoamingTableSupported() {
        return false;
    }
}

