/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.proxy;

import at.mrdevelopment.toolkit.log.ESLLogger;
import com.google.common.base.Strings;
import java.net.Authenticator;
import java.net.PasswordAuthentication;

public class ProxyAuthenticator
extends Authenticator {
    static ESLLogger logger = ESLLogger.getLogger(ProxyAuthenticator.class);
    private final String proxyUser;
    private final String proxyPassword;

    public static ProxyAuthenticator of(String user, String password) {
        return new ProxyAuthenticator(user, password);
    }

    public ProxyAuthenticator(String proxyUser, String proxyPassword) {
        this.proxyUser = proxyUser;
        this.proxyPassword = proxyPassword;
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        logger.debug("PasswordAuthentication: %s:%d, %s, %s, %s, %s, %s, %s", new Object[]{this.getRequestingHost(), this.getRequestingPort(), this.getRequestingPrompt(), this.getRequestingProtocol(), this.getRequestingScheme(), this.getRequestingSite(), this.getRequestingURL(), this.getRequestorType()});
        return new PasswordAuthentication(this.proxyUser, Strings.nullToEmpty((String)this.proxyPassword).toCharArray());
    }

    public String toString() {
        return String.format("%s:*****", this.proxyUser);
    }
}

