/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.transaction;

import at.mrdevelopment.esl.persistence.DatasetException;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;

public class StatelessORMTransaction<T> {
    private final StatelessSession session;
    private final Transaction transaction;

    public StatelessORMTransaction(StatelessSession session) throws DatasetException {
        try {
            this.session = session;
            this.transaction = session.beginTransaction();
        }
        catch (Exception exc) {
            throw new DatasetException((Throwable)exc);
        }
    }

    public List<T> query(Query query) throws DatasetException {
        try {
            List result = query.list();
            this.commit();
            return result;
        }
        catch (Exception exc) {
            this.rollback();
            throw new DatasetException((Throwable)exc);
        }
    }

    public void commit() throws DatasetException {
        try {
            this.transaction.commit();
        }
        catch (Exception exc) {
            throw new DatasetException((Throwable)exc);
        }
    }

    public void rollback() throws DatasetException {
        try {
            this.transaction.rollback();
        }
        catch (Exception exc) {
            throw new DatasetException((Throwable)exc);
        }
    }

    public Query createSQLQuery(String queryString, Class<?> entityClass) throws DatasetException {
        try {
            return this.session.createSQLQuery(queryString).addEntity(entityClass);
        }
        catch (Exception exc) {
            throw new DatasetException((Throwable)exc);
        }
    }

    public Query createSQLQuery(String queryString) throws DatasetException {
        try {
            return this.session.createSQLQuery(queryString);
        }
        catch (Exception exc) {
            throw new DatasetException((Throwable)exc);
        }
    }

    public Query createQuery(String queryString) throws DatasetException {
        try {
            return this.session.createQuery(queryString);
        }
        catch (Exception exc) {
            throw new DatasetException((Throwable)exc);
        }
    }

    public int queryCount(Query countQuery) throws DatasetException {
        try {
            int count = ((Number)countQuery.uniqueResult()).intValue();
            this.commit();
            return count;
        }
        catch (Exception exc) {
            this.rollback();
            throw new DatasetException((Throwable)exc);
        }
    }

    public int deleteFromQuery(Query query) throws DatasetException {
        ScrollableResults cursor = null;
        try {
            cursor = query.scroll(ScrollMode.FORWARD_ONLY);
            int count = 0;
            while (cursor.next()) {
                Object record = cursor.get(0);
                this.session.delete(record);
                ++count;
            }
            this.tryCloseCursor(cursor);
            cursor = null;
            this.commit();
            int n = count;
            return n;
        }
        catch (Exception exc) {
            this.rollback();
            throw new DatasetException((Throwable)exc);
        }
        finally {
            this.tryCloseCursor(cursor);
        }
    }

    public int executeUpdate(Query query) throws DatasetException {
        try {
            int count = query.executeUpdate();
            this.commit();
            return count;
        }
        catch (Exception exc) {
            this.rollback();
            throw new DatasetException((Throwable)exc);
        }
    }

    public void closeSession() throws DatasetException {
        try {
            this.session.close();
        }
        catch (Exception exc) {
            throw new DatasetException((Throwable)exc);
        }
    }

    private void tryCloseCursor(ScrollableResults cursor) throws DatasetException {
        if (this.session != null && cursor != null) {
            try {
                cursor.close();
                cursor = null;
            }
            catch (Exception exc) {
                throw new DatasetException((Throwable)exc);
            }
        }
    }
}

