/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.transaction;

import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.maintenance.DatabaseUtils;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import java.sql.SQLException;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public class DatabaseCleanupTransaction<UNUSED>
extends ORMTransaction<UNUSED> {
    private final SessionFactory sessionFactory;

    public DatabaseCleanupTransaction(SessionFactory sessionFactory) throws DatasetException {
        super((Session)sessionFactory.getCurrentSession());
        this.sessionFactory = sessionFactory;
        this.changeIsolationLevel(this.getSession());
    }

    private void commitAndStart() throws DatasetException {
        try {
            this.commit();
        }
        catch (DatasetException exc) {
            this.rollback();
            throw exc;
        }
        this.startTransaction((Session)this.sessionFactory.getCurrentSession());
        this.changeIsolationLevel(this.getSession());
    }

    private void changeIsolationLevel(Session session) throws DatasetException {
        try {
            if (DatabaseUtils.isDerbyDatabase(session)) {
                session.connection().setTransactionIsolation(1);
            }
        }
        catch (HibernateException exc) {
            throw new DatasetException((Throwable)exc);
        }
        catch (SQLException exc) {
            throw new DatasetException((Throwable)exc);
        }
    }

    @Override
    public int executeUpdate(Query updateQuery) throws DatasetException {
        int recordCount = super.executeUpdate(updateQuery);
        this.commitAndStart();
        return recordCount;
    }

    @Override
    public int deleteFromQuery(Criteria criteria, int batchSize) throws DatasetException {
        int recordCount = super.deleteFromQuery(criteria, batchSize);
        this.commitAndStart();
        return recordCount;
    }

    @Override
    public int deleteFromQuery(Query query, int batchSize) throws DatasetException {
        int recordCount = super.deleteFromQuery(query, batchSize);
        this.commitAndStart();
        return recordCount;
    }
}

