/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.transaction;

import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.TransactionSupplier;
import at.mrdevelopment.esl.persistence.transaction.AbstractTransactionSupplier;
import at.mrdevelopment.esl.persistence.transaction.BatchUpdateORMTransaction;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;

public class BatchUpdateTransactionSupplier
extends AbstractTransactionSupplier<BatchUpdateORMTransaction<?>> {
    private final int updateBatchSize;

    public static BatchUpdateTransactionSupplier fromTransactionSupplier(TransactionSupplier transactionSupplier, int updateBatchSize) {
        if (!(transactionSupplier instanceof AbstractTransactionSupplier)) {
            throw new IllegalArgumentException("Transaction supplier must be instance of AbstractTransactionSupplier");
        }
        return new BatchUpdateTransactionSupplier(((AbstractTransactionSupplier)transactionSupplier).getSessionFactory(), updateBatchSize);
    }

    public BatchUpdateTransactionSupplier(SessionFactory sessionFactory, int updateBatchSize) {
        super(sessionFactory);
        this.updateBatchSize = updateBatchSize;
    }

    @Override
    public BatchUpdateORMTransaction<?> newTransaction() throws DatasetException {
        try {
            return new BatchUpdateORMTransaction(this.getSessionFactory(), this.updateBatchSize);
        }
        catch (HibernateException exc) {
            throw new DatasetException((Throwable)exc);
        }
    }
}

