/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.query.DefaultQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.record.UpdateStatus;
import at.mrdevelopment.esl.server.WaitingTaskCache;
import at.mrdevelopment.esl.update.Update;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class WaitingUpdatesQuery
extends DefaultQuery<UpdateStatus, Void> {
    private final WaitingTaskCache waitingTaskCache;

    public WaitingUpdatesQuery(WaitingTaskCache waitingTasksCache) throws DatasetException {
        super("updatestatus/waiting", UpdateStatus.class, Void.class);
        this.waitingTaskCache = waitingTasksCache;
    }

    @Override
    protected List<UpdateStatus> getRecords(QueryRestriction<Void> queryRestriction, Transaction<?> transaction) throws DatasetException {
        Collection<Object> waitingTasks = this.waitingTaskCache.getWaitingAndDelayedTasksSorted();
        if (Config.isIgnoreArchiveTasksForUpdateStatusQueries()) {
            waitingTasks = Collections2.filter(waitingTasks, (Predicate)new Predicate<Update>(){

                public boolean apply(Update update) {
                    return !update.isInternal();
                }
            });
        }
        return new ArrayList<UpdateStatus>(Collections.unmodifiableCollection(Collections2.transform(waitingTasks, (Function)new Function<Update, UpdateStatus>(){

            public UpdateStatus apply(Update update) {
                return update.getUpdateStatus();
            }
        })));
    }

    @Override
    public int getCount(QueryRestriction<Void> queryRestriction, Transaction<?> transaction) throws DatasetException {
        return this.waitingTaskCache.getWaitingAndDelayedTasksCount();
    }
}

