/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.ORMDataset;
import at.mrdevelopment.esl.persistence.query.ORMDatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.record.UpdateStatus;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import org.hibernate.Query;

public class UpdateStatusWithStartIdQuery
extends ORMDatasetQuery<UpdateStatus, Long> {
    private static final String QUERY = "from UpdateStatus u left join fetch u.taskRecord t left join fetch t.transaction where u.id > :id";
    private static final String COUNT_QUERY = "from UpdateStatus u where u.id > :id";

    public UpdateStatusWithStartIdQuery(ORMDataset<UpdateStatus> dataset) throws DatasetException {
        super(dataset, "updatestatus/startid", Long.class);
    }

    @Override
    protected Query getQuery(ORMTransaction<?> transaction, QueryRestriction<Long> queryRestriction) throws DatasetException {
        Long id = (Long)queryRestriction.getSearchKey();
        return transaction.createQuery("select u from UpdateStatus u left join fetch u.taskRecord t left join fetch t.transaction where u.id > :id order by u.id").setLong("id", id.longValue());
    }

    @Override
    protected Query getCountQuery(ORMTransaction<?> transaction, QueryRestriction<Long> queryRestriction) throws DatasetException {
        Long id = (Long)queryRestriction.getSearchKey();
        return transaction.createQuery("select count(u) from UpdateStatus u where u.id > :id").setParameter("id", (Object)id);
    }
}

