/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.ORMDataset;
import at.mrdevelopment.esl.persistence.query.ORMDatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.record.UpdateStatus;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import org.hibernate.Query;

public class UpdateStatusForLabelQuery
extends ORMDatasetQuery<UpdateStatus, LabelId> {
    private static final String QUERY = "from UpdateStatus u where u.id in (select max(su.id) from UpdateStatus su where su.taskRecord.page is not null and su.taskRecord.label = :label group by su.taskRecord.page)";

    public UpdateStatusForLabelQuery(ORMDataset<UpdateStatus> dataset) throws DatasetException {
        super(dataset, "status/label", LabelId.class);
    }

    @Override
    protected Query getQuery(ORMTransaction<?> transaction, QueryRestriction<LabelId> queryRestriction) throws DatasetException {
        LabelId labelId = (LabelId)queryRestriction.getSearchKey();
        return transaction.createQuery("select u from UpdateStatus u where u.id in (select max(su.id) from UpdateStatus su where su.taskRecord.page is not null and su.taskRecord.label = :label group by su.taskRecord.page) order by u.taskRecord.page").setLong("label", labelId.getId());
    }

    @Override
    protected Query getCountQuery(ORMTransaction<?> transaction, QueryRestriction<LabelId> queryRestriction) throws DatasetException {
        LabelId labelId = (LabelId)queryRestriction.getSearchKey();
        return transaction.createQuery("select count(u) from UpdateStatus u where u.id in (select max(su.id) from UpdateStatus su where su.taskRecord.page is not null and su.taskRecord.label = :label group by su.taskRecord.page)").setLong("label", labelId.getId());
    }
}

