/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.ORMDataset;
import at.mrdevelopment.esl.persistence.query.ORMDatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.record.UpdateStatus;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import java.util.UUID;
import org.hibernate.Query;

public class UpdateHistoryForTaskQuery
extends ORMDatasetQuery<UpdateStatus, UUID> {
    private static final String QUERY = "from UpdateStatus u where u.taskRecord.id = (select su.taskRecord.id from UpdateStatus su where su.taskId = :taskId)";

    public UpdateHistoryForTaskQuery(ORMDataset<UpdateStatus> dataset) throws DatasetException {
        super(dataset, "updatestatus/taskhistory", UUID.class);
    }

    @Override
    protected Query getQuery(ORMTransaction<?> transaction, QueryRestriction<UUID> queryRestriction) throws DatasetException {
        UUID taskId = (UUID)queryRestriction.getSearchKey();
        return transaction.createQuery("select u from UpdateStatus u where u.taskRecord.id = (select su.taskRecord.id from UpdateStatus su where su.taskId = :taskId) order by u.id").setParameter("taskId", (Object)taskId);
    }

    @Override
    protected Query getCountQuery(ORMTransaction<?> transaction, QueryRestriction<UUID> queryRestriction) throws DatasetException {
        UUID taskId = (UUID)queryRestriction.getSearchKey();
        return transaction.createQuery("select count(u) from UpdateStatus u where u.taskRecord.id = (select su.taskRecord.id from UpdateStatus su where su.taskId = :taskId)").setParameter("taskId", (Object)taskId);
    }
}

