/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.annotation.Serialize;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.query.DefaultQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.type.UpdateError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections15.CollectionUtils;
import org.apache.commons.collections15.Transformer;

public class UpdateErrorDescriptionQuery
extends DefaultQuery<UpdateErrorDescription, Void> {
    public UpdateErrorDescriptionQuery() {
        super("description/updateerror", UpdateErrorDescription.class, Void.class);
    }

    @Override
    protected List<UpdateErrorDescription> getRecords(QueryRestriction<Void> queryRestriction, Transaction<?> transaction) throws DatasetException {
        return (List)CollectionUtils.collect(Arrays.asList(UpdateError.values()), (Transformer)new Transformer<UpdateError, UpdateErrorDescription>(){

            public UpdateErrorDescription transform(UpdateError updateError) {
                return new UpdateErrorDescription(updateError);
            }
        }, new ArrayList(UpdateError.values().length));
    }

    public static class UpdateErrorDescription {
        private final int errorCode;
        private final String description;

        public UpdateErrorDescription(UpdateError updateError) {
            this(updateError.getCode(), updateError.getDescription());
        }

        public UpdateErrorDescription(int errorCode, String description) {
            this.errorCode = errorCode;
            this.description = description;
        }

        @Serialize
        public int getErrorCode() {
            return this.errorCode;
        }

        @Serialize
        public String getDescription() {
            return this.description;
        }
    }
}

