/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.core.Status;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.ORMDataset;
import at.mrdevelopment.esl.persistence.query.AbstractUpdateStatusQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.record.UpdateStatus;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import org.hibernate.Query;

public class UnsuccessfulUpdatesQuery
extends AbstractUpdateStatusQuery<Void> {
    private static final String QUERY = "from UpdateStatus u where u.status in " + Status.UNSUCCESSFUL_SQL + " and ((u.retriesLeft = 0 and u.taskRecord.retryValidUntil is null) or u.taskRecord.retryValidUntil < current_timestamp()) and ";

    public UnsuccessfulUpdatesQuery(ORMDataset<UpdateStatus> dataset) throws DatasetException {
        super(dataset, "updatestatus/unsuccessful", QUERY, Void.class);
    }

    @Override
    public Query getQuery(ORMTransaction<?> transaction, QueryRestriction<Void> queryRestriction) throws DatasetException {
        return transaction.createQuery("select max(u) " + this.getBaseQuery() + " group by u.taskRecord");
    }

    @Override
    protected Query getCountQuery(ORMTransaction<?> transaction, QueryRestriction<Void> queryRestriction) throws DatasetException {
        return transaction.createQuery("select count(u) " + this.getBaseQuery());
    }
}

