/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.query.AbstractDatasetQuery;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.persistence.record.Commitable;
import java.util.List;

public class PredefinedDatasetQuery<T extends Commitable, S>
extends AbstractDatasetQuery<T, Void> {
    private final DatasetQuery<T, S> query;
    private final S searchKey;

    public PredefinedDatasetQuery(DatasetQuery<T, S> query, S searchKey) {
        this.query = query;
        this.searchKey = searchKey;
    }

    public String getUrl() {
        return this.query.getUrl() + "/" + this.searchKey.toString().toLowerCase();
    }

    public Class<T> getRecordClass() {
        return this.query.getRecordClass();
    }

    public List<String> getCustomFields() {
        return this.query.getCustomFields();
    }

    public Class<Void> getParameterClass() {
        return Void.class;
    }

    public boolean isSingleRecordExpected() {
        return this.query.isSingleRecordExpected();
    }

    public QueryResult<T> getResult(QueryRestriction<Void> queryRestriction, Transaction<?> transaction) throws DatasetException {
        return this.query.getResult(this.wrapQueryRestriction(queryRestriction), transaction);
    }

    public int getCount(QueryRestriction<Void> queryRestriction, Transaction<?> transaction) throws DatasetException {
        return this.query.getCount(this.wrapQueryRestriction(queryRestriction), transaction);
    }

    private QueryRestriction<S> wrapQueryRestriction(QueryRestriction<Void> queryRestriction) {
        return QueryRestriction.newSearchQuery((Class)this.query.getParameterClass(), this.searchKey, (Integer)queryRestriction.getPage(), (Integer)queryRestriction.getRecordsPerPage(), (int)Config.getRecordsPerPage());
    }
}

