/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.admin.platform.config.LogLevel;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.annotation.Serialize;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.query.DefaultQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.toolkit.log.LogEntry;
import at.mrdevelopment.toolkit.log.LogList;
import at.mrdevelopment.toolkit.log.MemoryLogger;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections15.CollectionUtils;
import org.apache.commons.collections15.Transformer;
import org.joda.time.DateTime;

public class LoggingQuery
extends DefaultQuery<Logging, LogLevel> {
    public LoggingQuery() {
        super("logging/level", Logging.class, LogLevel.class);
    }

    @Override
    protected List<Logging> getRecords(QueryRestriction<LogLevel> queryRestriction, Transaction<?> transaction) throws DatasetException {
        if (MemoryLogger.isEnabled()) {
            LogLevel logLevel = (LogLevel)queryRestriction.getSearchKey();
            List logList = LogList.getInstance().filterByLevel(logLevel.toLevel());
            return (List)CollectionUtils.collect((Iterable)logList, (Transformer)new Transformer<LogEntry, Logging>(){

                public Logging transform(LogEntry logEntry) {
                    return new Logging(logEntry);
                }
            }, new ArrayList(logList.size()));
        }
        return new ArrayList<Logging>(0);
    }

    public static class Logging {
        private final LogEntry logEntry;

        public Logging(LogEntry logEntry) {
            this.logEntry = logEntry;
        }

        @Serialize
        public DateTime getTime() {
            return this.logEntry.getTime();
        }

        @Serialize
        public String getLogger() {
            return this.logEntry.getLoggerName();
        }

        @Serialize
        public String getMessage() {
            return this.logEntry.getLogMessage();
        }

        @Serialize
        public String getLevel() {
            return this.logEntry.getLogLevel().toString();
        }
    }
}

