/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.core.PowerStatus;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.Dataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.DefaultDatasetQuery;
import at.mrdevelopment.esl.persistence.query.PredefinedDatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.record.LabelInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LabelsWithPowerStatusQuery
extends DefaultDatasetQuery<LabelInfo, PowerStatus> {
    public static DatasetQuery<LabelInfo, Void> newPowerBadLabelsQuery(Dataset<LabelInfo> dataset) {
        LabelsWithPowerStatusQuery query = new LabelsWithPowerStatusQuery(dataset);
        return new PredefinedDatasetQuery(query, PowerStatus.BAD);
    }

    public static DatasetQuery<LabelInfo, Void> newPowerLowLabelsQuery(Dataset<LabelInfo> dataset) {
        LabelsWithPowerStatusQuery query = new LabelsWithPowerStatusQuery(dataset);
        return new PredefinedDatasetQuery(query, PowerStatus.LOW);
    }

    public LabelsWithPowerStatusQuery(Dataset<LabelInfo> dataset) {
        super(dataset, "labelinfo/powerstatus", PowerStatus.class);
    }

    @Override
    protected List<LabelInfo> getRecords(QueryRestriction<PowerStatus> queryRestriction, Transaction<?> transaction) throws DatasetException {
        PowerStatus status = (PowerStatus)queryRestriction.getSearchKey();
        ArrayList<LabelInfo> labelsWithStatus = new ArrayList<LabelInfo>();
        for (LabelInfo labelInfo : this.dataset.queryAll(transaction)) {
            if (labelInfo.getPowerStatus() != status) continue;
            labelsWithStatus.add(labelInfo);
        }
        return Collections.unmodifiableList(labelsWithStatus);
    }
}

