/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.Dataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.query.DefaultDatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.record.LabelInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class LabelsModifiedAfterQuery
extends DefaultDatasetQuery<LabelInfo, DateTime> {
    public LabelsModifiedAfterQuery(Dataset<LabelInfo> dataset) {
        super(dataset, "labelinfo/modifiedafter", DateTime.class);
    }

    @Override
    protected List<LabelInfo> getRecords(QueryRestriction<DateTime> queryRestriction, Transaction<?> transaction) throws DatasetException {
        DateTime queryTime = (DateTime)queryRestriction.getSearchKey();
        if (queryTime == null || queryTime.isEqual(0L)) {
            return Collections.unmodifiableList(this.dataset.queryAll(transaction));
        }
        ArrayList<LabelInfo> modifiedLabels = new ArrayList<LabelInfo>();
        for (LabelInfo labelInfo : this.dataset.queryAll(transaction)) {
            if (labelInfo.getLastModifiedTime() == null || !labelInfo.getLastModifiedTime().isAfter((ReadableInstant)queryTime) && !labelInfo.getLastModifiedTime().isEqual((ReadableInstant)queryTime)) continue;
            modifiedLabels.add(labelInfo);
        }
        return Collections.unmodifiableList(modifiedLabels);
    }
}

