/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.ORMDataset;
import at.mrdevelopment.esl.persistence.query.ORMDatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.record.LabelPageContent;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import org.hibernate.Query;

public class LabelPageContentForLabelQuery
extends ORMDatasetQuery<LabelPageContent, LabelId> {
    private static final String QUERY = "from LabelPageContent l where l.id in (select max(ll.id) from LabelPageContent ll where ll.label = :label and ll.updateImage != null group by ll.page)";

    public LabelPageContentForLabelQuery(ORMDataset<LabelPageContent> dataset) throws DatasetException {
        super(dataset, "labelpagecontent/label", LabelId.class);
    }

    @Override
    protected Query getQuery(ORMTransaction<?> transaction, QueryRestriction<LabelId> queryRestriction) throws DatasetException {
        LabelId labelId = (LabelId)queryRestriction.getSearchKey();
        return transaction.createQuery("select l from LabelPageContent l where l.id in (select max(ll.id) from LabelPageContent ll where ll.label = :label and ll.updateImage != null group by ll.page) order by l.page").setLong("label", labelId.getId());
    }

    @Override
    protected Query getCountQuery(ORMTransaction<?> transaction, QueryRestriction<LabelId> queryRestriction) throws DatasetException {
        LabelId labelId = (LabelId)queryRestriction.getSearchKey();
        return transaction.createQuery("select count(l) from LabelPageContent l where l.id in (select max(ll.id) from LabelPageContent ll where ll.label = :label and ll.updateImage != null group by ll.page)").setLong("label", labelId.getId());
    }
}

