/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.Dataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.query.DefaultDatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.record.LabelInfoHistoryRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class LabelInfoHistoryUpdatedAfterQuery
extends DefaultDatasetQuery<LabelInfoHistoryRecord, DateTime> {
    public LabelInfoHistoryUpdatedAfterQuery(Dataset<LabelInfoHistoryRecord> dataset) {
        super(dataset, "history/labelinfo/updatedafter", DateTime.class);
    }

    @Override
    protected List<LabelInfoHistoryRecord> getRecords(QueryRestriction<DateTime> queryRestriction, Transaction<?> transaction) throws DatasetException {
        DateTime queryTime = (DateTime)queryRestriction.getSearchKey();
        if (queryTime == null || queryTime.isEqual(0L)) {
            return Collections.unmodifiableList(this.dataset.queryAll(transaction));
        }
        ArrayList<LabelInfoHistoryRecord> labelInfoHistoryRecords = new ArrayList<LabelInfoHistoryRecord>();
        for (LabelInfoHistoryRecord labelInfoHistoryRecord : this.dataset.queryAll(transaction)) {
            if (labelInfoHistoryRecord.getUpdatedAt() == null || !labelInfoHistoryRecord.getUpdatedAt().isAfter((ReadableInstant)queryTime) && !labelInfoHistoryRecord.getUpdatedAt().isEqual((ReadableInstant)queryTime)) continue;
            labelInfoHistoryRecords.add(labelInfoHistoryRecord);
        }
        return Collections.unmodifiableList(labelInfoHistoryRecords);
    }
}

