/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.ORMDataset;
import at.mrdevelopment.esl.persistence.query.ORMDatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.record.LabelInfoHistoryRecord;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import org.hibernate.Query;

public class LabelInfoHistoryForLabelQuery
extends ORMDatasetQuery<LabelInfoHistoryRecord, LabelId> {
    private static final String QUERY = "from LabelInfoHistoryRecord l where l.label = :label";

    public LabelInfoHistoryForLabelQuery(ORMDataset<LabelInfoHistoryRecord> dataset) throws DatasetException {
        super(dataset, "history/labelinfo/label", LabelId.class);
    }

    @Override
    protected Query getQuery(ORMTransaction<?> transaction, QueryRestriction<LabelId> queryRestriction) throws DatasetException {
        LabelId labelId = (LabelId)queryRestriction.getSearchKey();
        return transaction.createQuery("select l from LabelInfoHistoryRecord l where l.label = :label order by l.id").setLong("label", labelId.getId());
    }

    @Override
    protected Query getCountQuery(ORMTransaction<?> transaction, QueryRestriction<LabelId> queryRestriction) throws DatasetException {
        LabelId labelId = (LabelId)queryRestriction.getSearchKey();
        return transaction.createQuery("select count(l) from LabelInfoHistoryRecord l where l.label = :label").setParameter("label", (Object)labelId.getId());
    }
}

