/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.annotation.Serialize;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.query.DefaultQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.type.LabelError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections15.CollectionUtils;
import org.apache.commons.collections15.Transformer;

public class LabelErrorDescriptionQuery
extends DefaultQuery<LabelErrorDescription, Void> {
    public LabelErrorDescriptionQuery() {
        super("description/labelerror", LabelErrorDescription.class, Void.class);
    }

    @Override
    protected List<LabelErrorDescription> getRecords(QueryRestriction<Void> queryRestriction, Transaction<?> transaction) throws DatasetException {
        return (List)CollectionUtils.collect(Arrays.asList(LabelError.values()), (Transformer)new Transformer<LabelError, LabelErrorDescription>(){

            public LabelErrorDescription transform(LabelError labelError) {
                return new LabelErrorDescription(labelError);
            }
        }, new ArrayList());
    }

    public static class LabelErrorDescription {
        private final int errorCode;
        private final String description;

        public LabelErrorDescription(LabelError labelError) {
            this(labelError.getCode(), labelError.getDescription());
        }

        public LabelErrorDescription(int errorCode, String description) {
            this.errorCode = errorCode;
            this.description = description;
        }

        @Serialize
        public int getErrorCode() {
            return this.errorCode;
        }

        @Serialize
        public String getDescription() {
            return this.description;
        }
    }
}

