/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.ORMDataset;
import at.mrdevelopment.esl.persistence.query.ORMDatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.record.LabelDetail;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import org.hibernate.Query;

public class LabelDataForLabelQuery
extends ORMDatasetQuery<LabelDetail, LabelId> {
    private static final String QUERY = "from LabelDetail d where d.label = :label and d.value is not null";

    public LabelDataForLabelQuery(ORMDataset<LabelDetail> dataset) throws DatasetException {
        super(dataset, "labeldetail/label", LabelId.class);
    }

    @Override
    protected Query getQuery(ORMTransaction<?> transaction, QueryRestriction<LabelId> queryRestriction) throws DatasetException {
        LabelId labelId = (LabelId)queryRestriction.getSearchKey();
        return transaction.createQuery("select d from LabelDetail d where d.label = :label and d.value is not null order by d.id").setLong("label", labelId.getId());
    }

    @Override
    protected Query getCountQuery(ORMTransaction<?> transaction, QueryRestriction<LabelId> queryRestriction) throws DatasetException {
        LabelId labelId = (LabelId)queryRestriction.getSearchKey();
        return transaction.createQuery("select count(d) from LabelDetail d where d.label = :label and d.value is not null").setParameter("label", (Object)labelId.getId());
    }
}

