/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.Dataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.query.DefaultDatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.record.Template;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class InvalidTemplatesQuery
extends DefaultDatasetQuery<Template, Void> {
    static ESLLogger logger = ESLLogger.getLogger(InvalidTemplatesQuery.class);
    private final XMLToolkit xmlToolkit = new XMLToolkit();

    public InvalidTemplatesQuery(Dataset<Template> dataset) throws InitializationException {
        super(dataset, "template/invalid", Void.class);
    }

    @Override
    protected List<Template> getRecords(QueryRestriction<Void> queryRestriction, Transaction<?> transaction) throws DatasetException {
        ArrayList<Template> invalidTemplates = new ArrayList<Template>();
        this.dataset.reload(transaction);
        for (Template template : this.dataset.queryAll(transaction)) {
            try {
                File templateFile = new File(Config.getTemplatePath(), template.getTemplateFilename());
                this.xmlToolkit.getDocumentRootFromFile(templateFile);
            }
            catch (SerializeException exc) {
                logger.warn("Template %s invalid", new Object[]{template.getName()});
                logger.logExceptionIfDebugEnabled((Throwable)exc);
                invalidTemplates.add(template);
            }
            catch (FileNotFoundException exc) {
                logger.warn("Template %s not found", new Object[]{template.getName()});
                invalidTemplates.add(template);
            }
        }
        return Collections.unmodifiableList(invalidTemplates);
    }
}

