/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.annotation.Serialize;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.query.DefaultQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.query.QueryUrlRegistry;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections15.CollectionUtils;
import org.apache.commons.collections15.Transformer;

public class EnumDescriptionQuery<E extends Enum<E>>
extends DefaultQuery<EnumDescription, Void> {
    static ESLLogger logger = ESLLogger.getLogger(EnumDescriptionQuery.class);
    private final Enum<E>[] values;

    public EnumDescriptionQuery(Class<E> type, Enum<E>[] values) throws InitializationException {
        super(QueryUrlRegistry.getEnumDescriptionUrl(type), EnumDescription.class, Void.class);
        this.values = values;
    }

    @Override
    protected List<EnumDescription> getRecords(QueryRestriction<Void> queryRestriction, Transaction<?> transaction) throws DatasetException {
        return (List)CollectionUtils.collect(Arrays.asList(this.values), (Transformer)new Transformer<Enum<E>, EnumDescription>(){

            public EnumDescription transform(Enum<E> value) {
                return new EnumDescription(value);
            }
        }, new ArrayList(this.values.length));
    }

    public static class EnumDescription {
        private final Class<?> type;
        private final String name;
        private final String description;

        public EnumDescription(Enum<?> value) {
            this.type = value.getClass();
            this.name = value.name();
            this.description = this.readDescription(value);
        }

        private String readDescription(Enum<?> value) {
            try {
                Method method = value.getClass().getMethod("getDescription", new Class[0]);
                return (String)method.invoke(value, new Object[0]);
            }
            catch (Exception exc) {
                logger.logExceptionIfDebugEnabled((Throwable)exc);
                return null;
            }
        }

        @Serialize
        public String getType() {
            return this.type.getSimpleName();
        }

        @Serialize
        public String getName() {
            return this.name;
        }

        @Serialize
        public String getDescription() {
            return this.description;
        }
    }
}

