/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.core.accesspoint.AccessPointType;
import at.mrdevelopment.esl.core.accesspoint.AccessPointTypeMapping;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.Dataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.query.DefaultDatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.record.AccessPointInfo;
import at.mrdevelopment.toolkit.Version;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AccessPointAdvancedCommunicationProtocolQuery
extends DefaultDatasetQuery<AccessPointInfo, Void> {
    private static final Version advancedProtocolSupportedVersion = Version.fromString((String)"1.8.0");

    public AccessPointAdvancedCommunicationProtocolQuery(Dataset<AccessPointInfo> dataset) {
        super(dataset, "accesspointinfo/advancedprotocol", Void.class);
    }

    @Override
    protected List<AccessPointInfo> getRecords(QueryRestriction<Void> queryRestriction, Transaction<?> transaction) throws DatasetException {
        ArrayList<AccessPointInfo> supportedAccessPoints = new ArrayList<AccessPointInfo>();
        if (!Config.isAccessPointUseThinMode()) {
            int configuredAccessPoints = 0;
            for (AccessPointInfo accessPointInfo : this.dataset.queryAll(transaction)) {
                if (!accessPointInfo.isOnline() && !accessPointInfo.isOffline()) continue;
                ++configuredAccessPoints;
                Version version = accessPointInfo.getVersion();
                AccessPointType accessPointType = AccessPointTypeMapping.getType((int)accessPointInfo.getAccessPointId());
                if (accessPointType != AccessPointType.IMAGOTAG || version == null || !version.isEqualOrNewer(advancedProtocolSupportedVersion)) continue;
                supportedAccessPoints.add(accessPointInfo);
            }
            if (configuredAccessPoints != supportedAccessPoints.size()) {
                supportedAccessPoints.clear();
            }
        }
        return Collections.unmodifiableList(supportedAccessPoints);
    }
}

