/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.maintenance.migration;

import at.mrdevelopment.esl.persistence.maintenance.migration.DatabaseMigrationTask;
import at.mrdevelopment.toolkit.log.ESLLogger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.hibernate.util.JDBCExceptionReporter;

public class SimpleDatabaseMigrationTask
implements DatabaseMigrationTask {
    static ESLLogger logger = ESLLogger.getLogger(SimpleDatabaseMigrationTask.class);
    private final String query;

    public SimpleDatabaseMigrationTask(String query) {
        this.query = query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeMigration(SessionFactory sessionFactory) {
        Session session = sessionFactory.openSession();
        Transaction transaction = null;
        Logger jdbcLogger = Logger.getLogger(JDBCExceptionReporter.class);
        Level level = jdbcLogger.getLevel();
        if (!logger.isDebugEnabled()) {
            jdbcLogger.setLevel(Level.OFF);
        }
        try {
            SQLQuery sqlQuery = session.createSQLQuery(this.query);
            logger.debug("Executing migration query: %s", new Object[]{this.query});
            transaction = session.beginTransaction();
            sqlQuery.executeUpdate();
            transaction.commit();
        }
        catch (Exception exc) {
            logger.info("Could not execute migration query: %s", new Object[]{exc.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
            if (transaction != null) {
                try {
                    transaction.rollback();
                }
                catch (HibernateException ignore) {
                    // empty catch block
                }
            }
        }
        finally {
            if (!logger.isDebugEnabled()) {
                jdbcLogger.setLevel(level);
            }
            session.close();
        }
    }
}

