/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.maintenance.job;

import at.mrdevelopment.esl.persistence.maintenance.job.ConfigurationProfile;
import at.mrdevelopment.esl.persistence.maintenance.job.ConfigurationProfiles;
import at.mrdevelopment.esl.persistence.maintenance.job.TimeBasedConfigurationProfile;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;

public class TimeBasedConfigurationProfileTest {
    private static final String CONFIGURATION_PROFILES = "configurationProfiles";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String SCHEDULES = "schedules";
    private static final String SYNC_PROFILE = "syncProfile";
    private static final String NORMAL = "NORMAL";
    private static final String ULTRA_FAST_RESPONSE = "ULTRA_FAST_RESPONSE";
    private static final String PLUGIN_ARCHIVE_ENABLED = "pluginArchiveEnabled";
    private static final String DATABASE_STATISTICS_RELOAD_MINUTES = "databaseStatisticsReloadMinutes";
    private static final String DATABASE_COMPRESSION_ENABLED = "databaseCompressionEnabled";
    private static final String IGNORE_EXPERIMENTAL_LABE_ERRORS = "ignoreExperimentalLabelErrors";
    private static final String FALSE = "false";
    private static final String FIVE = "5";
    private static final String SCHEDULE_1 = "0 * * ? * *";
    private static final String SCHEDULE_2 = "15 * * ? * *";
    private static final String SCHEDULE_3 = "30 * * ? * *";
    private static final String SCHEDULE_4 = "45 * * ? * *";
    private static final String SCHEDULE_5 = "0 15,30,45 * ? * *";
    private static final String SCHEDULE_6 = "0 */30 * ? * *";
    private static final String SCHEDULE_7 = "0 0 12 ? * MON-FRI";
    private static final String SCHEDULE_8 = "0 0 12 LW * ?";
    private static final String SCHEDULE_9 = "   0    *   *  ? * * ";
    private static final String INVALID_SCHEDULE = "*";
    private static final String EMPTY_CONFIGURATION = "{\"configurationProfiles\":[]}";
    private static final String VALID_CONFIGURATION = "{\"configurationProfiles\":[{\"key\":\"syncProfile\",\"value\":\"NORMAL\",\"schedules\":[\"0 * * ? * *\",\"15 * * ? * *\"]},{\"key\":\"syncProfile\",\"value\":\"ULTRA_FAST_RESPONSE\",\"schedules\":[\"30 * * ? * *\",\"45 * * ? * *\"]},{\"key\":\"pluginArchiveEnabled\",\"value\":\"false\",\"schedules\":[\"0 15,30,45 * ? * *\"]},{\"key\":\"databaseStatisticsReloadMinutes\",\"value\":\"5\",\"schedules\":[\"0 */30 * ? * *\"]},{\"key\":\"databaseCompressionEnabled\",\"value\":\"false\",\"schedules\":[\"0 0 12 ? * MON-FRI\"]},{\"key\":\"ignoreExperimentalLabelErrors\",\"value\":\"false\",\"schedules\":[\"0 0 12 LW * ?\"]}]}";
    private static final String INVALID_CONFIGURATION = "{\"configurationProfiles\":[{\"key\":\"syncProfile\",\"value\":\"NORMAL\",\"schedules\":[\"*\"]}]}";
    private static final String TO_BE_NORMALIZED_CONFIGURATION = "{\"configurationProfiles\":[{\"key\":\"     syncProfile      \",\"value\":\"       NORMAL       \",\"schedules\":[\"   0    *   *  ? * * \"]}]}";
    private final ConfigurationProfiles emptyConfigurationProfiles = ConfigurationProfiles.toConfigurationProfiles(new ArrayList<ConfigurationProfile>());
    private final ConfigurationProfiles configurationProfiles = ConfigurationProfiles.toConfigurationProfiles(Arrays.asList(ConfigurationProfile.toConfigurationProfile("syncProfile", "NORMAL", Arrays.asList("0 * * ? * *", "15 * * ? * *")), ConfigurationProfile.toConfigurationProfile("syncProfile", "ULTRA_FAST_RESPONSE", Arrays.asList("30 * * ? * *", "45 * * ? * *")), ConfigurationProfile.toConfigurationProfile("pluginArchiveEnabled", "false", Arrays.asList("0 15,30,45 * ? * *")), ConfigurationProfile.toConfigurationProfile("databaseStatisticsReloadMinutes", "5", Arrays.asList("0 */30 * ? * *")), ConfigurationProfile.toConfigurationProfile("databaseCompressionEnabled", "false", Arrays.asList("0 0 12 ? * MON-FRI")), ConfigurationProfile.toConfigurationProfile("ignoreExperimentalLabelErrors", "false", Arrays.asList("0 0 12 LW * ?"))));

    @Test
    public void testFromJson() {
        Collection<TimeBasedConfigurationProfile> timeBasedConfigurationProfiles = TimeBasedConfigurationProfile.fromConfigurationString(VALID_CONFIGURATION);
        Assert.assertTrue((boolean)timeBasedConfigurationProfiles.contains(new TimeBasedConfigurationProfile(SYNC_PROFILE, NORMAL, SCHEDULE_1)));
        Assert.assertTrue((boolean)timeBasedConfigurationProfiles.contains(new TimeBasedConfigurationProfile(SYNC_PROFILE, NORMAL, SCHEDULE_2)));
        Assert.assertTrue((boolean)timeBasedConfigurationProfiles.contains(new TimeBasedConfigurationProfile(SYNC_PROFILE, ULTRA_FAST_RESPONSE, SCHEDULE_3)));
        Assert.assertTrue((boolean)timeBasedConfigurationProfiles.contains(new TimeBasedConfigurationProfile(SYNC_PROFILE, ULTRA_FAST_RESPONSE, SCHEDULE_4)));
        Assert.assertTrue((boolean)timeBasedConfigurationProfiles.contains(new TimeBasedConfigurationProfile(PLUGIN_ARCHIVE_ENABLED, FALSE, SCHEDULE_5)));
        Assert.assertTrue((boolean)timeBasedConfigurationProfiles.contains(new TimeBasedConfigurationProfile(DATABASE_STATISTICS_RELOAD_MINUTES, FIVE, SCHEDULE_6)));
        Assert.assertTrue((boolean)timeBasedConfigurationProfiles.contains(new TimeBasedConfigurationProfile(DATABASE_COMPRESSION_ENABLED, FALSE, SCHEDULE_7)));
        Assert.assertTrue((boolean)timeBasedConfigurationProfiles.contains(new TimeBasedConfigurationProfile(IGNORE_EXPERIMENTAL_LABE_ERRORS, FALSE, SCHEDULE_8)));
    }

    @Test
    public void testToJson() {
        String json = new Gson().toJson((Object)this.configurationProfiles);
        Assert.assertEquals((Object)VALID_CONFIGURATION, (Object)json);
    }

    @Test
    public void testFromEmptyJson() {
        Collection<TimeBasedConfigurationProfile> timeBasedConfigurationProfiles = TimeBasedConfigurationProfile.fromConfigurationString(EMPTY_CONFIGURATION);
        Assert.assertTrue((boolean)timeBasedConfigurationProfiles.isEmpty());
    }

    @Test
    public void testToEmptyJson() {
        String json = new Gson().toJson((Object)this.emptyConfigurationProfiles);
        Assert.assertEquals((Object)EMPTY_CONFIGURATION, (Object)json);
    }

    @Test
    public void testToBeNormalizedJson() {
        try {
            Collection<TimeBasedConfigurationProfile> timeBasedConfigurationProfiles = TimeBasedConfigurationProfile.fromConfigurationString(TO_BE_NORMALIZED_CONFIGURATION);
            Assert.assertTrue((boolean)timeBasedConfigurationProfiles.contains(new TimeBasedConfigurationProfile(SYNC_PROFILE, NORMAL, SCHEDULE_1)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidJson() {
        Collection<TimeBasedConfigurationProfile> profiles = TimeBasedConfigurationProfile.fromConfigurationString(INVALID_CONFIGURATION);
        Assert.assertTrue((boolean)profiles.isEmpty());
    }

    @Test
    public void testInvalid1Json() {
        Collection<TimeBasedConfigurationProfile> profiles = TimeBasedConfigurationProfile.fromConfigurationString("alskdjfaslkjfdl");
        Assert.assertTrue((boolean)profiles.isEmpty());
    }
}

