/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.maintenance.job;

import at.mrdevelopment.esl.persistence.maintenance.job.ConfigurationProfile;
import at.mrdevelopment.esl.persistence.maintenance.job.ConfigurationProfiles;
import at.mrdevelopment.esl.persistence.maintenance.job.TimeBasedConfigurationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.quartz.CronExpression;

public class TimeBasedConfigurationProfile {
    static ESLLogger logger = ESLLogger.getLogger(TimeBasedConfigurationProfile.class);
    private static final String CONFIG_KEY = "timeBasedConfigurationJobs";
    private final String key;
    private final String value;
    private final String schedule;

    public static Collection<TimeBasedConfigurationProfile> fromConfigurationString(String configurationString) {
        ArrayList<TimeBasedConfigurationProfile> timeBasedConfigurationProfiles = new ArrayList<TimeBasedConfigurationProfile>();
        if (!Strings.isNullOrEmpty((String)configurationString)) {
            try {
                Collection<ConfigurationProfile> configurationProfiles = TimeBasedConfigurationProfile.getConfigurationProfiles(configurationString).getConfigurationProfiles();
                for (ConfigurationProfile configurationProfile : configurationProfiles) {
                    for (String schedule : configurationProfile.getSchedules()) {
                        timeBasedConfigurationProfiles.add(new TimeBasedConfigurationProfile(TimeBasedConfigurationProfile.normalize(configurationProfile.getKey()), TimeBasedConfigurationProfile.normalize(configurationProfile.getValue()), TimeBasedConfigurationProfile.normalize(schedule)));
                    }
                }
            }
            catch (TimeBasedConfigurationException exc) {
                logger.warn(String.format("Could not load time based configuration: %s", exc.getMessage()));
                logger.logExceptionIfDebugEnabled((Throwable)exc);
            }
        }
        return timeBasedConfigurationProfiles;
    }

    public TimeBasedConfigurationProfile(String key, String value, String schedule) {
        this.key = key;
        this.value = value;
        this.schedule = schedule;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getKey());
        builder.append("=");
        builder.append(this.getValue());
        builder.append("-");
        builder.append(this.getSchedule());
        return builder.toString();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getKey());
        builder.append((Object)this.getValue());
        builder.append((Object)this.getSchedule());
        return builder.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof TimeBasedConfigurationProfile)) {
            return false;
        }
        TimeBasedConfigurationProfile otherTimeBasedConfigurationProfile = (TimeBasedConfigurationProfile)other;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getKey(), (Object)otherTimeBasedConfigurationProfile.getKey());
        builder.append((Object)this.getValue(), (Object)otherTimeBasedConfigurationProfile.getValue());
        builder.append((Object)this.getSchedule(), (Object)otherTimeBasedConfigurationProfile.getSchedule());
        return builder.isEquals();
    }

    private static ConfigurationProfiles getConfigurationProfiles(String configurationString) throws TimeBasedConfigurationException {
        try {
            ConfigurationProfiles configurationProfiles = (ConfigurationProfiles)new Gson().fromJson(configurationString, ConfigurationProfiles.class);
            if (configurationProfiles == null || configurationProfiles.getConfigurationProfiles() == null) {
                throw new TimeBasedConfigurationException("Configuration profile json is not valid", new Object[0]);
            }
            TimeBasedConfigurationProfile.validateConfigurationProfiles(configurationProfiles);
            return configurationProfiles;
        }
        catch (Exception exc) {
            throw new TimeBasedConfigurationException(exc);
        }
    }

    private static void validateConfigurationProfiles(ConfigurationProfiles configurationProfiles) throws TimeBasedConfigurationException {
        for (ConfigurationProfile configurationProfile : configurationProfiles.getConfigurationProfiles()) {
            if (configurationProfile.getKey().equals(CONFIG_KEY)) {
                throw new TimeBasedConfigurationException(String.format("%s not allowed to be scheduled for reconfiguration", CONFIG_KEY), new Object[0]);
            }
            for (String schedule : configurationProfile.getSchedules()) {
                if (CronExpression.isValidExpression((String)schedule)) continue;
                throw new TimeBasedConfigurationException("Configuration profile json is not valid", new Object[0]);
            }
        }
    }

    private static String normalize(String configuration) {
        return configuration.trim().replaceAll(" +", " ");
    }
}

