/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.maintenance.job;

import at.mrdevelopment.esl.custom.impl.Level1Implementation;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.maintenance.job.AbstractESLJob;
import at.mrdevelopment.toolkit.log.ESLLogger;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class TimeBasedConfigurationJob
extends AbstractESLJob {
    static ESLLogger logger = ESLLogger.getLogger(TimeBasedConfigurationJob.class);
    private static final String KEY_CONFIGURATION_KEY = "configurationKey";
    private static final String KEY_CONFIGURATION_VALUE = "configurationValue";

    @Override
    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        Level1Implementation level1 = this.getLevel1(context);
        String key = this.getKey(context);
        String value = this.getValue(context);
        logger.info("Executing time based configuration job: %s=%s", new Object[]{key, value});
        try {
            level1.updateConfiguration(key, value);
        }
        catch (DatasetException exception) {
            throw new JobExecutionException((Throwable)exception);
        }
    }

    @Override
    public String getJobIdentifier(JobExecutionContext context) {
        return (String)context.getJobDetail().getJobDataMap().get((Object)"jobIdentifier");
    }

    private String getKey(JobExecutionContext context) {
        return (String)context.getJobDetail().getJobDataMap().get((Object)KEY_CONFIGURATION_KEY);
    }

    private String getValue(JobExecutionContext context) {
        return (String)context.getJobDetail().getJobDataMap().get((Object)KEY_CONFIGURATION_VALUE);
    }
}

