/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.maintenance.job;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.labeltype.DisplayColors;
import at.mrdevelopment.esl.core.labeltype.LabelType;
import at.mrdevelopment.esl.custom.impl.Level1Implementation;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.LabelInfoDataset;
import at.mrdevelopment.esl.persistence.dataset.NoTransaction;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.maintenance.job.AbstractESLJob;
import at.mrdevelopment.esl.persistence.record.LabelInfo;
import at.mrdevelopment.esl.tasks.RefreshDisplayTask;
import at.mrdevelopment.esl.type.LabelTypeStringParser;
import at.mrdevelopment.esl.type.TaskOrder;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.toolkit.log.ESLLogger;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class RefreshLabelsJob
extends AbstractESLJob {
    static ESLLogger logger = ESLLogger.getLogger(RefreshLabelsJob.class);

    @Override
    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        int refreshAfterHours = Config.getAutomaticDisplayRefreshAfterHours();
        LabelTypeStringParser labelTypeParser = new LabelTypeStringParser();
        Collection<LabelType> labelTypes = this.parseLabelTypesFromString(Config.getAutomaticDisplayRefreshLabelTypes(), labelTypeParser);
        Collection<String> tags = this.parseTagsFromString(Config.getAutomaticDisplayRefreshTags());
        DateTime now = DateTime.now();
        if (refreshAfterHours > 0) {
            ArrayList<RefreshDisplayTask> refreshTasks = new ArrayList<RefreshDisplayTask>();
            LabelInfoDataset labelInfoDataset = this.getLabelInfoDataset(context);
            for (LabelInfo labelInfo : labelInfoDataset.queryAll((Transaction<?>)NoTransaction.get())) {
                DateTime refreshTime;
                DateTime lastRefreshTime;
                if (!this.isValidLabelType(labelInfo, labelTypes) && !this.isValidLabelTag(labelInfo, tags) || (lastRefreshTime = labelInfo.getLastRefreshTime()) == null || !(refreshTime = lastRefreshTime.plusHours(refreshAfterHours)).isBefore((ReadableInstant)now)) continue;
                LabelId labelId = labelInfo.getLabelId();
                RefreshDisplayTask refreshTask = new RefreshDisplayTask(labelId, TaskPriority.LOW, 0L, false);
                refreshTasks.add(refreshTask);
                labelInfo.setLastRefreshTime(now);
            }
            if (refreshTasks.size() > 0) {
                try {
                    Level1Implementation level1 = this.getLevel1(context);
                    String transactionTitle = String.format("Refreshing display of %d labels", refreshTasks.size());
                    TaskOrder taskOrder = new TaskOrder(transactionTitle, 0L, refreshTasks);
                    level1.addTasks(taskOrder);
                    logger.info(transactionTitle);
                }
                catch (DatasetException exc) {
                    throw new JobExecutionException((Throwable)exc);
                }
            }
        }
    }

    private boolean isValidLabelTag(LabelInfo labelInfo, Collection<String> tags) {
        if (tags.isEmpty()) {
            return true;
        }
        return !Collections.disjoint(tags, labelInfo.getTags());
    }

    private boolean isValidLabelType(LabelInfo labelInfo, Collection<LabelType> labelTypes) {
        if (labelTypes.isEmpty()) {
            return true;
        }
        return labelTypes.contains(labelInfo.getLabelId().getLabelType());
    }

    private Collection<String> parseTagsFromString(String tagsString) {
        return tagsString != null ? Sets.newHashSet((Iterable)Splitter.on((String)";").split((CharSequence)tagsString.toUpperCase())) : new HashSet();
    }

    private Collection<LabelType> parseLabelTypesFromString(String labelTypesString, LabelTypeStringParser labelTypeParser) {
        HashSet<LabelType> types = new HashSet<LabelType>();
        if (labelTypesString != null && !labelTypesString.isEmpty()) {
            Iterable splitted = Splitter.on((String)";").split((CharSequence)labelTypesString);
            for (String type : splitted) {
                if (type.toLowerCase().equals("red")) {
                    types.addAll(this.getRedLabelTypes());
                    continue;
                }
                try {
                    LabelType labelType = labelTypeParser.parseLabelType(type.toUpperCase());
                    if (labelType == null) continue;
                    types.add(labelType);
                }
                catch (Exception exc) {}
            }
        }
        return types;
    }

    private Collection<LabelType> getRedLabelTypes() {
        return Collections2.filter((Collection)Lists.newArrayList((Object[])LabelType.values()), (Predicate)new Predicate<LabelType>(){

            public boolean apply(LabelType labelType) {
                return labelType.getDisplayColors() == DisplayColors.BLACK_WHITE_RED;
            }
        });
    }
}

