/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.maintenance.job;

import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.maintenance.job.AbstractESLJob;
import at.mrdevelopment.esl.server.PersistLabelInfoCache;
import at.mrdevelopment.toolkit.log.ESLLogger;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class PersistLabelInfoJob
extends AbstractESLJob {
    static ESLLogger logger = ESLLogger.getLogger(PersistLabelInfoJob.class);

    @Override
    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        PersistLabelInfoCache persistLabelInfoCache = this.getLabelInfoCache(context);
        logger.info("Persisting label infos");
        try {
            Transaction transaction = this.getTransactionSupplier(context).newTransaction();
            try {
                persistLabelInfoCache.persistInfos(transaction);
                if (!transaction.isCommitted()) {
                    transaction.commit();
                }
            }
            catch (Exception exc) {
                transaction.rollback();
                throw exc;
            }
        }
        catch (Exception exc) {
            throw new JobExecutionException((Throwable)exc);
        }
    }

    @Override
    protected void jobNotExecuted(JobExecutionContext context) {
        PersistLabelInfoCache persistLabelInfoCache = this.getLabelInfoCache(context);
        persistLabelInfoCache.clearCache();
    }
}

