/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.maintenance.job;

import at.mrdevelopment.esl.configuration.PluginConfiguration;
import at.mrdevelopment.esl.custom.level1.Level1Interface;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.toolkit.InitializationException;

public class LabelDataCollectorConfiguration {
    public static final String CONFIG_ENABLED = "Enabled";
    public static final String CONFIG_SCHEDULE = "Schedule";
    private final String configPrefix;
    private final boolean enabledDefault;
    private final String scheduleDefault;
    private final PluginConfiguration pluginConfiguration;

    public LabelDataCollectorConfiguration(String configPrefix, PluginConfiguration pluginConfiguration, boolean enabledDefault, String scheduleDefault, Level1Interface level1, Transaction<?> transaction) throws DatasetException, InitializationException {
        this.configPrefix = configPrefix;
        this.pluginConfiguration = pluginConfiguration;
        this.enabledDefault = enabledDefault;
        this.scheduleDefault = scheduleDefault;
        if (configPrefix.startsWith("plugin")) {
            pluginConfiguration.getBoolean(configPrefix + CONFIG_ENABLED, enabledDefault, transaction);
            pluginConfiguration.getString(configPrefix + CONFIG_SCHEDULE, scheduleDefault, transaction);
        }
    }

    public boolean isEnabled(Transaction<?> transaction) throws DatasetException {
        return this.pluginConfiguration.getBoolean(this.configPrefix + CONFIG_ENABLED, this.enabledDefault, transaction);
    }

    public String getSchedule(Transaction<?> transaction) throws DatasetException {
        return this.pluginConfiguration.getString(this.configPrefix + CONFIG_SCHEDULE, this.scheduleDefault, transaction);
    }

    public String getScheduleKey() {
        return this.configPrefix + CONFIG_SCHEDULE;
    }

    public String getEnabledKey() {
        return this.configPrefix + CONFIG_ENABLED;
    }
}

