/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.maintenance.job;

import at.mrdevelopment.esl.persistence.maintenance.job.JobConfiguration;
import at.mrdevelopment.esl.persistence.maintenance.job.JobStatistic;
import at.mrdevelopment.esl.server.ServiceScheduler;
import at.mrdevelopment.toolkit.InitializationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.joda.time.ReadableInstant;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;

public class JobStatistics {
    private final List<JobStatistic> statistics = new ArrayList<JobStatistic>();

    public JobStatistics(ServiceScheduler serviceScheduler, Scheduler scheduler, Map<String, JobConfiguration> jobs) throws InitializationException {
        try {
            for (Map.Entry<String, JobConfiguration> entry : jobs.entrySet()) {
                String jobIdentifier = entry.getValue().getJobIdentifier();
                JobKey jobKey = entry.getValue().getJobKey();
                JobDetail jobDetail = scheduler.getJobDetail(jobKey);
                JobExecutionContext executionContext = null;
                boolean enabled = entry.getValue().isEnabled();
                Date earliestStart = null;
                Trigger trigger = null;
                for (Trigger triggerForJob : scheduler.getTriggersOfJob(jobKey)) {
                    if (earliestStart != null && (triggerForJob.getNextFireTime() == null || triggerForJob.getNextFireTime().getTime() >= earliestStart.getTime())) continue;
                    earliestStart = triggerForJob.getNextFireTime();
                    trigger = triggerForJob;
                }
                for (JobExecutionContext context : scheduler.getCurrentlyExecutingJobs()) {
                    if (!context.getJobDetail().getKey().getName().equals(jobKey.getName())) continue;
                    executionContext = context;
                    break;
                }
                this.statistics.add(new JobStatistic(enabled, jobIdentifier, jobDetail, trigger, executionContext));
                Collections.sort(this.statistics, new Comparator<JobStatistic>(){

                    @Override
                    public int compare(JobStatistic o1, JobStatistic o2) {
                        if (o1 == null || o2 == null || o1.getNextFireTime() == null || o2.getNextFireTime() == null) {
                            return 0;
                        }
                        return o1.getNextFireTime().compareTo((ReadableInstant)o2.getNextFireTime());
                    }
                });
            }
        }
        catch (SchedulerException exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    public List<JobStatistic> getStatistics() {
        return Collections.unmodifiableList(this.statistics);
    }
}

