/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.maintenance.job;

import org.joda.time.DateTime;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.Trigger;

public class JobStatistic {
    private final boolean enabled;
    private final Trigger trigger;
    private final JobExecutionContext jobContext;
    private final String name;
    private JobDetail jobDetail;

    public JobStatistic(boolean enabled, String name, JobDetail jobDetail, Trigger trigger, JobExecutionContext jobContext) {
        this.enabled = enabled;
        this.name = name;
        this.jobDetail = jobDetail;
        this.trigger = trigger;
        this.jobContext = jobContext;
    }

    public DateTime getNextFireTime() {
        return this.trigger != null ? new DateTime((Object)this.trigger.getNextFireTime()) : null;
    }

    public DateTime getPreviousFireTime() {
        Object previousExecutionObj;
        if (this.jobDetail.getJobDataMap().containsKey((Object)"previousExecution") && (previousExecutionObj = this.jobDetail.getJobDataMap().get((Object)"previousExecution")) != null) {
            return (DateTime)previousExecutionObj;
        }
        return null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isManuallyTriggered() {
        if (this.jobContext != null) {
            return this.jobContext.getMergedJobDataMap().containsKey((Object)"manualTrigger") && this.jobContext.getMergedJobDataMap().getBoolean("manualTrigger");
        }
        return this.trigger.getJobDataMap().containsKey((Object)"manualTrigger") && this.trigger.getJobDataMap().getBoolean("manualTrigger");
    }

    public String getName() {
        return this.name;
    }

    public int getExecutionCount() {
        String key = String.format("%sExecutionCount", this.name);
        return this.jobDetail.getJobDataMap().containsKey((Object)key) ? this.jobDetail.getJobDataMap().getInt(key) : 0;
    }

    public long getExecutionMillis() {
        String key = String.format("%sExecutionTime", this.name);
        return this.jobDetail.getJobDataMap().containsKey((Object)key) ? this.jobDetail.getJobDataMap().getLongValue(key) : 0L;
    }

    public String getCronDescription() {
        return this.trigger != null && this.trigger instanceof CronTrigger ? ((CronTrigger)this.trigger).getExpressionSummary() : "";
    }

    public boolean isRunning() {
        return this.jobContext != null;
    }

    public long getCurrentExecutionMillis() {
        if (this.isRunning()) {
            return System.currentTimeMillis() - this.jobContext.getFireTime().getTime();
        }
        return 0L;
    }

    public JobDataMap getJobDataMap() {
        return this.jobDetail.getJobDataMap();
    }

    public String toString() {
        return String.format("%s: executionCount=%d, lastExecutionMillis:%d ms, manuallyTriggered=%b", this.getName(), this.getExecutionCount(), this.getExecutionMillis(), this.isManuallyTriggered());
    }
}

