/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.maintenance.job;

import at.mrdevelopment.esl.persistence.maintenance.job.CronJobConfiguration;
import at.mrdevelopment.esl.persistence.maintenance.job.ESLJob;
import org.apache.commons.lang.BooleanUtils;
import org.quartz.JobKey;

public abstract class BaseJobConfiguration
implements CronJobConfiguration {
    private final Class<? extends ESLJob> jobClass;
    private final String jobIdentifier;
    private String enabled;

    public BaseJobConfiguration(Class<? extends ESLJob> jobClass) {
        this(jobClass, jobClass.getSimpleName());
    }

    public BaseJobConfiguration(Class<? extends ESLJob> jobClass, String jobIdentifier) {
        this.jobClass = jobClass;
        this.jobIdentifier = jobIdentifier;
    }

    @Override
    public Class<? extends ESLJob> getJobClass() {
        return this.jobClass;
    }

    @Override
    public String getJobIdentifier() {
        return this.jobIdentifier;
    }

    @Override
    public boolean isEnabled() {
        try {
            return Integer.valueOf(this.enabled) > 0;
        }
        catch (NumberFormatException numberFormatException) {
            return BooleanUtils.toBoolean((String)this.enabled);
        }
    }

    @Override
    public JobKey getJobKey() {
        return new JobKey(this.getJobIdentifier());
    }

    public void updateEnabledState(String enabled) {
        this.enabled = enabled;
    }
}

