/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.maintenance.job;

import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.maintenance.job.BaseJobConfiguration;
import at.mrdevelopment.esl.persistence.maintenance.job.ESLJob;
import at.mrdevelopment.toolkit.log.ESLLogger;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.Collection;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.ScheduleBuilder;
import org.quartz.TriggerBuilder;

public abstract class AbstractCronJobConfiguration
extends BaseJobConfiguration {
    static ESLLogger logger = ESLLogger.getLogger(AbstractCronJobConfiguration.class);

    public AbstractCronJobConfiguration(Class<? extends ESLJob> jobClass) {
        super(jobClass);
    }

    public AbstractCronJobConfiguration(Class<? extends ESLJob> jobClass, String jobIdentifier) {
        super(jobClass, jobIdentifier);
    }

    public CronTrigger createTrigger() throws DatasetException {
        try {
            return this.createTriggerWithSchedule(this.getSchedule());
        }
        catch (DatasetException exc) {
            String defaultSchedule = this.getDefaultSchedule();
            logger.warn("Could not create trigger for job%s %s: %s", new Object[]{defaultSchedule != null ? " (using default schedule)" : "", this.getJobIdentifier(), exc.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
            return defaultSchedule != null ? this.createTriggerWithSchedule(defaultSchedule) : null;
        }
    }

    @Override
    public CronTrigger createTriggerWithSchedule(String scheduleValue) throws DatasetException {
        try {
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(this.getTriggerName()).startNow().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)scheduleValue).withMisfireHandlingInstructionIgnoreMisfires()).build();
            return trigger;
        }
        catch (Exception exc) {
            throw new DatasetException((Throwable)exc);
        }
    }

    @Override
    public String getTriggerName() {
        return String.format("%sTrigger", this.getJobIdentifier());
    }

    @Override
    public Collection<String> getCronExpressionSummary() {
        try {
            CronTrigger trigger = this.createTrigger();
            if (trigger != null) {
                String expressionSummary = trigger.getExpressionSummary();
                return Lists.newArrayList((Iterable)Splitter.on((String)"\n").trimResults().omitEmptyStrings().split((CharSequence)expressionSummary));
            }
            return null;
        }
        catch (DatasetException exc) {
            return null;
        }
    }

    public abstract String getDefaultSchedule();
}

