/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.maintenance;

import at.mrdevelopment.esl.persistence.maintenance.DatabaseMigration;
import at.mrdevelopment.toolkit.InitializationException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;

public class PostgreSQLMigration
extends DatabaseMigration {
    private static final String DISABLE_TRIGGER_FORMAT_STRING = "ALTER TABLE %s DISABLE TRIGGER ALL";
    private static final String ENABLE_TRIGGER_FORMAT_STRING = "ALTER TABLE %s ENABLE TRIGGER ALL";

    public PostgreSQLMigration(SessionFactory destinationSessionFactory, SessionFactory sourceSessionFactory) throws InitializationException {
        super(destinationSessionFactory, sourceSessionFactory);
    }

    @Override
    protected void disableConstraints(SessionFactory destinationSessionFactory) throws HibernateException, SQLException {
        this.updateConstraints(false, destinationSessionFactory);
    }

    private void updateConstraints(boolean enable, SessionFactory destinationSessionFactory) throws HibernateException, SQLException {
        Session session = destinationSessionFactory.openSession();
        try {
            ResultSet tables = session.connection().getMetaData().getTables(null, null, null, new String[]{"TABLE"});
            session.beginTransaction();
            while (tables.next()) {
                String tableName = tables.getString(3);
                SQLQuery disableTriggerQuery = session.createSQLQuery(String.format(enable ? ENABLE_TRIGGER_FORMAT_STRING : DISABLE_TRIGGER_FORMAT_STRING, tableName));
                disableTriggerQuery.executeUpdate();
            }
            session.getTransaction().commit();
        }
        catch (HibernateException exc) {
            session.getTransaction().rollback();
            throw exc;
        }
        catch (SQLException exc) {
            session.getTransaction().rollback();
            throw exc;
        }
        finally {
            session.close();
        }
    }

    @Override
    protected void enableConstraints(SessionFactory destinationSessionFactory) throws HibernateException, SQLException {
        this.updateConstraints(true, destinationSessionFactory);
    }
}

