/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.maintenance;

import at.mrdevelopment.esl.custom.impl.Level1Implementation;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.BatteryReplacementRecordDataset;
import at.mrdevelopment.esl.persistence.dataset.LabelActivePageDataset;
import at.mrdevelopment.esl.persistence.dataset.LabelDetailDataset;
import at.mrdevelopment.esl.persistence.dataset.LabelEventDataset;
import at.mrdevelopment.esl.persistence.dataset.LabelInfoHistoryDataset;
import at.mrdevelopment.esl.persistence.dataset.LabelPageContentDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.dataset.UpdateStatusDataset;
import at.mrdevelopment.esl.persistence.maintenance.DatabaseMaintenanceStrategy;
import at.mrdevelopment.esl.persistence.maintenance.DatabaseSizeStatistics;
import at.mrdevelopment.esl.persistence.maintenance.DefaultDatabaseMaintenanceStrategy;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.os.FileSystem;
import at.mrdevelopment.toolkit.os.FileSystemInfo;
import java.io.File;

public class DiskSpaceRelatedDatabaseMaintenanceStrategy
implements DatabaseMaintenanceStrategy {
    static ESLLogger logger = ESLLogger.getLogger(DiskSpaceRelatedDatabaseMaintenanceStrategy.class);
    private static final int SHUTDOWN_RATIO = 90;
    private final DefaultDatabaseMaintenanceStrategy defaultStrategy;
    private final File dataPartition;
    private FileSystemInfo fileSystemInfo;
    private boolean actionInProgress;

    public DiskSpaceRelatedDatabaseMaintenanceStrategy(File dataPartition) {
        this.dataPartition = dataPartition;
        this.defaultStrategy = new DefaultDatabaseMaintenanceStrategy();
    }

    @Override
    public void notifyFileSystemInfo(FileSystemInfo fileSystemInfo) {
        logger.info(String.format("Set FileSystemInfo for DiskSpaceRelatedDatabaseMaintenanceStrategy", fileSystemInfo));
        this.fileSystemInfo = fileSystemInfo;
    }

    @Override
    public void notifyDatabaseStatistics(DatabaseSizeStatistics statistics) {
    }

    @Override
    public void cleanup(Level1Implementation level1, UpdateStatusDataset updateStatusDataset, LabelInfoHistoryDataset labelInfoHistoryDataset, LabelPageContentDataset labelPageContentDataset, LabelActivePageDataset labelActivePageDataset, BatteryReplacementRecordDataset batteryReplacementDataset, LabelEventDataset labelEventDataset, LabelDetailDataset labelDetailDataset, Transaction<?> transaction) throws DatasetException {
        logger.info("call cleanup");
        if (!this.actionInProgress) {
            if (this.fileSystemInfo != null) {
                logger.info("FileSystemInfo is not null");
                FileSystem fileSystem = this.fileSystemInfo.getByFile(this.dataPartition);
                if (fileSystem != null && DiskSpaceRelatedDatabaseMaintenanceStrategy.isDiskSpaceUsageOverShutdownThreshold(fileSystem)) {
                    logger.info("Execute shutdown of service");
                    level1.shutdownService();
                    this.actionInProgress = true;
                }
            }
            this.defaultStrategy.cleanup(level1, updateStatusDataset, labelInfoHistoryDataset, labelPageContentDataset, labelActivePageDataset, batteryReplacementDataset, labelEventDataset, labelDetailDataset, transaction);
        }
    }

    private static double getRatio(long first, long second) {
        return (double)first / (double)second * 100.0;
    }

    private static boolean isDiskSpaceUsageOverShutdownThreshold(FileSystem dataPartitionFileSystem) {
        long partitionTotalSize = dataPartitionFileSystem.getTotalSpaceInBytes();
        long partitionUsedBytes = dataPartitionFileSystem.getUsedSpaceInBytes();
        double usedPercent = DiskSpaceRelatedDatabaseMaintenanceStrategy.getRatio(partitionUsedBytes, partitionTotalSize);
        if (usedPercent > 90.0) {
            logger.warn("Used disk space (%.2f %%) exeeds (%d %%) limit for file system %s ", new Object[]{usedPercent, 90, dataPartitionFileSystem.getFile().toString()});
            logger.error("Shutting down service due to low disk space on %s", new Object[]{dataPartitionFileSystem.getFile().toString()});
            return true;
        }
        return false;
    }

    public static boolean isPartitionOutOfSpace(File partition) {
        FileSystem fileSystem = new FileSystem(partition, null);
        return DiskSpaceRelatedDatabaseMaintenanceStrategy.isDiskSpaceUsageOverShutdownThreshold(fileSystem);
    }
}

