/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.maintenance;

import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.TransactionSupplier;
import at.mrdevelopment.esl.persistence.maintenance.CompressType;
import at.mrdevelopment.esl.persistence.maintenance.DatabaseUtils;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import at.mrdevelopment.toolkit.log.ComputationTimeLogger;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.List;
import org.hibernate.SQLQuery;
import org.hibernate.SessionFactory;

public class DerbyTrimDatabase {
    static ESLLogger logger = ESLLogger.getLogger(DerbyTrimDatabase.class);
    private static final String LIST_TABLES_QUERY = "SELECT SCHEMANAME, TABLENAME FROM sys.sysschemas s, sys.systables t WHERE s.schemaid = t.schemaid and t.tabletype = 'T'";
    private final CompressType compressType;

    public DerbyTrimDatabase(SessionFactory sessionFactory) {
        this(CompressType.INPLACE_COMPRESS);
    }

    public DerbyTrimDatabase(CompressType compressType) {
        this.compressType = compressType;
    }

    public void trim(TransactionSupplier transactionSupplier) throws DatasetException {
        ORMTransaction<?> ormTransaction = ORMTransaction.fromTransaction(transactionSupplier.newTransaction());
        List list = null;
        try {
            boolean isDerbyDb = DatabaseUtils.isDerbyDatabase(ormTransaction.getSession());
            if (isDerbyDb) {
                SQLQuery listTablesQuery = (SQLQuery)ormTransaction.createSQLQuery(LIST_TABLES_QUERY);
                list = listTablesQuery.list();
            } else {
                logger.warn("Trimming is not supported by the selected database driver");
            }
            ormTransaction.commit();
        }
        catch (Exception exc) {
            ormTransaction.rollback();
            throw new DatasetException((Throwable)exc);
        }
        if (list != null && list.size() > 0) {
            int count = 0;
            logger.info("Executing %s trim of %d Derby database tables", new Object[]{this.compressType.getArgument(), list.size()});
            for (Object[] entry : list) {
                this.trimTable(entry, transactionSupplier);
                logger.info("Trimmed %d of %d tables", new Object[]{++count, list.size()});
            }
            logger.info("Finished trimming all Derby database tables");
        }
    }

    private void trimTable(Object[] entry, TransactionSupplier transactionSupplier) throws DatasetException {
        if (entry.length == 2) {
            ORMTransaction<?> ormTransaction = ORMTransaction.fromTransaction(transactionSupplier.newTransaction());
            try {
                ComputationTimeLogger timeLogger = new ComputationTimeLogger(logger);
                String schema = entry[0].toString();
                String table = entry[1].toString();
                SQLQuery compressQuery = (SQLQuery)ormTransaction.createSQLQuery(this.compressType.getQuery());
                compressQuery.setString(0, schema);
                compressQuery.setString(1, table);
                timeLogger.start();
                compressQuery.executeUpdate();
                timeLogger.logTimeInfo(String.format("Trimming table %s", table));
                ormTransaction.commit();
            }
            catch (Exception exc) {
                ormTransaction.rollback();
                throw new DatasetException((Throwable)exc);
            }
        }
    }
}

