/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.maintenance;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.custom.impl.Level1Implementation;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.BatteryReplacementRecordDataset;
import at.mrdevelopment.esl.persistence.dataset.LabelActivePageDataset;
import at.mrdevelopment.esl.persistence.dataset.LabelDetailDataset;
import at.mrdevelopment.esl.persistence.dataset.LabelEventDataset;
import at.mrdevelopment.esl.persistence.dataset.LabelInfoHistoryDataset;
import at.mrdevelopment.esl.persistence.dataset.LabelPageContentDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.dataset.UpdateStatusDataset;
import at.mrdevelopment.esl.persistence.maintenance.DatabaseMaintenanceStrategy;
import at.mrdevelopment.esl.persistence.maintenance.DatabaseSizeStatistics;
import at.mrdevelopment.toolkit.log.ComputationTimeLogger;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.os.FileSystemInfo;

public class DefaultDatabaseMaintenanceStrategy
implements DatabaseMaintenanceStrategy {
    static ESLLogger logger = ESLLogger.getLogger(DefaultDatabaseMaintenanceStrategy.class);

    @Override
    public void cleanup(Level1Implementation level1, UpdateStatusDataset updateStatusDataset, LabelInfoHistoryDataset labelInfoHistoryDataset, LabelPageContentDataset labelPageContentDataset, LabelActivePageDataset labelActivePageDataset, BatteryReplacementRecordDataset batteryReplacementDataset, LabelEventDataset labelEventDataset, LabelDetailDataset labelDetailDataset, Transaction<?> transaction) throws DatasetException {
        this.cleanup(updateStatusDataset, labelInfoHistoryDataset, labelPageContentDataset, labelActivePageDataset, batteryReplacementDataset, labelEventDataset, labelDetailDataset, Config.getCleanupMaxRecords(), Config.getCleanupBatchSize(), Config.getCleanupMaxLabelHistoryRecords(), transaction);
    }

    public void cleanup(UpdateStatusDataset updateStatusDataset, LabelInfoHistoryDataset labelInfoHistoryDataset, LabelPageContentDataset labelPageContentDataset, LabelActivePageDataset labelActivePageDataset, BatteryReplacementRecordDataset batteryReplacementDataset, LabelEventDataset labelEventDataset, LabelDetailDataset labelDetailDataset, int maxCleanupRecords, int batchSize, int maxCleanupLabelHistoryRecords, Transaction<?> transaction) throws DatasetException {
        logger.info("Running database cleanup");
        ComputationTimeLogger timeLogger = new ComputationTimeLogger(logger);
        timeLogger.start();
        updateStatusDataset.cleanupUpdateStatus(Config.getCleanupUpdateStatusAfterDays(), maxCleanupRecords, batchSize, transaction);
        updateStatusDataset.cleanupArchiveTasks(Config.getCleanupArchiveTasksAfterDays(), maxCleanupRecords, batchSize, transaction);
        labelDetailDataset.cleanupHistory(Config.getCleanupArchiveTasksAfterDays(), maxCleanupRecords, transaction);
        labelInfoHistoryDataset.cleanupHistory(Config.getCleanupLabelInfoHistoryAfterDays(), maxCleanupLabelHistoryRecords, transaction);
        batteryReplacementDataset.cleanupHistory(Config.getCleanupBatteryReplacementAfterDays(), maxCleanupRecords, transaction);
        labelEventDataset.cleanupEvents(Config.getCleanupLabelEventsAfterDays(), maxCleanupRecords, transaction);
        labelPageContentDataset.cleanupContent(transaction);
        labelActivePageDataset.cleanupContent(transaction);
        timeLogger.logTimeInfo("Finished database cleanup");
    }

    @Override
    public void notifyFileSystemInfo(FileSystemInfo fileSystemInfo) {
    }

    @Override
    public void notifyDatabaseStatistics(DatabaseSizeStatistics statistics) {
    }
}

