/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.maintenance;

import at.mrdevelopment.esl.persistence.maintenance.DatabaseMigration;
import at.mrdevelopment.esl.persistence.maintenance.PostgreSQLMigration;
import at.mrdevelopment.toolkit.InitializationException;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;

public class DatabaseMigrationFactory {
    private static final String DERBY_NAME = "Apache Derby Embedded JDBC Driver";
    private static final String POSTGRES_NAME = "PostgreSQL Native Driver";

    public DatabaseMigration generateMigration(SessionFactory destinationSessionFactory, File sourceDatabaseConfiguration) throws InitializationException {
        try {
            Map entityInfos = destinationSessionFactory.getAllClassMetadata();
            SessionFactory sourceSessionFactory = this.initSessionFactory(sourceDatabaseConfiguration, entityInfos.keySet());
            String sourceDriverName = this.getDatabaseDriverName(sourceSessionFactory);
            String destinationDriverName = this.getDatabaseDriverName(destinationSessionFactory);
            if (sourceDriverName != null && sourceDriverName.equals(DERBY_NAME) && destinationDriverName != null && destinationDriverName.equals(POSTGRES_NAME)) {
                return new PostgreSQLMigration(destinationSessionFactory, sourceSessionFactory);
            }
        }
        catch (SQLException exc) {
            throw new InitializationException((Throwable)exc);
        }
        return null;
    }

    private SessionFactory initSessionFactory(File configFile, Set<String> entityClasses) throws HibernateException {
        try {
            Configuration configuration = new Configuration().configure(configFile);
            for (String className : entityClasses) {
                configuration.addAnnotatedClass(Class.forName(className));
            }
            return configuration.buildSessionFactory();
        }
        catch (Throwable exc) {
            throw new HibernateException(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDatabaseDriverName(SessionFactory sessionFactory) throws SQLException {
        Session session = sessionFactory.openSession();
        try {
            DatabaseMetaData metaData;
            Connection connection;
            if (session != null && (connection = session.connection()) != null && (metaData = connection.getMetaData()) != null) {
                String string = metaData.getDriverName();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }
}

