/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.maintenance;

import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;

public class DatabaseMetaDataWrapper {
    static ESLLogger logger = ESLLogger.getLogger(DatabaseMetaDataWrapper.class);
    private final DatabaseMetaData databaseMetaData;

    public DatabaseMetaDataWrapper(SessionFactory sessionFactory) throws InitializationException {
        Session session = null;
        DatabaseMetaData databaseMetaData = null;
        try {
            session = sessionFactory.openSession();
            databaseMetaData = session.connection().getMetaData();
        }
        catch (SQLException exception) {
            throw new InitializationException((Throwable)exception);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        if (databaseMetaData == null) {
            throw new IllegalStateException("Could not get database meta data.");
        }
        this.databaseMetaData = databaseMetaData;
    }

    public String getDatabaseProductName() {
        return this.getMetaData("DatabaseProductName");
    }

    public String getDatabaseProductVersion() {
        return this.getMetaData("DatabaseProductVersion");
    }

    public String getDriverName() {
        return this.getMetaData("DriverName");
    }

    public String getDriverVersion() {
        return this.getMetaData("DriverVersion");
    }

    public String getURL() {
        return this.getMetaData("URL");
    }

    private String getMetaData(String metaData) {
        String metaDataValue = null;
        try {
            metaDataValue = DatabaseMetaData.class.getMethod("get" + metaData, new Class[0]).invoke((Object)this.databaseMetaData, new Object[0]).toString();
        }
        catch (Exception exception) {
            logger.logException((Throwable)exception);
        }
        return metaDataValue != null ? metaDataValue : "N/A";
    }
}

