/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.maintenance;

import at.mrdevelopment.esl.persistence.maintenance.CompressType;
import java.io.File;

public class DatabaseMaintenanceOptions {
    private final boolean create;
    private final boolean cleanup;
    private final CompressType compressDbType;
    private final boolean purge;
    private final boolean migrate;
    private final File migrationDatabaseConfiguration;

    public DatabaseMaintenanceOptions(boolean create, boolean cleanup, CompressType compressDbType, boolean purge, boolean migrate, File migrationDatabaseConfiguration) {
        this.create = create;
        this.cleanup = cleanup;
        this.compressDbType = compressDbType;
        this.purge = purge;
        this.migrate = migrate;
        this.migrationDatabaseConfiguration = migrationDatabaseConfiguration;
    }

    public boolean isCreate() {
        return this.create;
    }

    public boolean isCleanup() {
        return this.cleanup;
    }

    public boolean isCompress() {
        return this.compressDbType != null;
    }

    public CompressType getCompressDbType() {
        return this.compressDbType;
    }

    public boolean isPurge() {
        return this.purge;
    }

    public boolean isMigrate() {
        return this.migrate;
    }

    public File getMigrationDatabaseConfiguration() {
        return this.migrationDatabaseConfiguration;
    }

    public boolean isShutdownService() {
        return this.isCreate() || this.isCleanup() || this.isCompress() || this.isMigrate() || this.isPurge();
    }

    public void printMessage() {
        if (this.isCreate()) {
            System.out.println("Created internal database tables");
        }
        if (this.isCleanup()) {
            System.out.println("Cleaned up database tables");
        }
        if (this.isCompress()) {
            System.out.println("Compressed database tables");
        }
        if (this.isMigrate()) {
            System.out.println("Database migration finished");
        }
        if (this.isPurge()) {
            System.out.println("Purging database tables finished");
        }
    }
}

