/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.dataset;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.KeepDeletedORMDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.record.CommitState;
import at.mrdevelopment.esl.persistence.record.User;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.authentication.UserId;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.Query;

public class UserDataset
extends KeepDeletedORMDataset<User> {
    public UserDataset(Map<Role, DatasetPermissions> datasetPermissions) throws InitializationException, DatasetException {
        super(User.class, datasetPermissions);
    }

    public User queryByUsername(String username, Transaction<?> transaction) throws DatasetException {
        ORMTransaction<?> ormTransaction = ORMTransaction.fromTransaction(transaction);
        Query query = ormTransaction.createQuery("select u from User u where u.username = :username").setParameter("username", (Object)username);
        return ormTransaction.querySingleRow(query, User.class);
    }

    @Override
    public void store(Collection<User> records, UserId user, Transaction<?> transaction) throws DatasetException {
        if (this.checkUsedDependentPermissions(records, user)) {
            super.store(records, user, transaction);
        } else {
            for (User record : records) {
                record.setCommitState(CommitState.FAILED);
                this.notifyRecordsModified(records, transaction);
            }
        }
    }

    private boolean checkUsedDependentPermissions(Collection<User> records, UserId user) {
        Iterator<User> i$;
        if (user.getRole().isAdmin() || user.getRole().isSystem()) {
            return true;
        }
        if (records.size() == 1 && (i$ = records.iterator()).hasNext()) {
            User record = i$.next();
            logger.info("Checking permissions for user %s to modify user %s", new Object[]{record.getUsername(), user.getUsername()});
            return record.getUsername().equals(user.getUsername());
        }
        return false;
    }
}

