/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.dataset;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.Status;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.DefaultInternalORMDataset;
import at.mrdevelopment.esl.persistence.dataset.DefaultORMDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.record.TaskRecord;
import at.mrdevelopment.esl.persistence.record.TransactionRecord;
import at.mrdevelopment.esl.persistence.record.TransactionStatusInfo;
import at.mrdevelopment.esl.persistence.record.UpdateImage;
import at.mrdevelopment.esl.persistence.record.UpdateStatus;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import at.mrdevelopment.esl.update.Update;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.log.ESLLogger;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.hibernate.Query;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class UpdateStatusDataset
extends DefaultInternalORMDataset<UpdateStatus> {
    static ESLLogger logger = ESLLogger.getLogger(UpdateStatusDataset.class);
    public static final String UPDATE_LOG_CRITERIA = "u.taskRecord.label is not null and (u.status = 'SUCCESSFUL' or (u.status in " + Status.FINISHED_SQL + " and u.retriesLeft = 0) or (u.status in " + Status.UNFINISHED_SQL + "))";
    public static final String UPDATE_LOG_CRITERIA_IGNORE_ARCHIVE_TASKS = UPDATE_LOG_CRITERIA + " and (u.internal = false or u.internal is null)";
    private final DefaultORMDataset<TaskRecord> taskRecordDataset;

    public UpdateStatusDataset(Map<Role, DatasetPermissions> datasetPermissions) throws InitializationException, DatasetException {
        super(UpdateStatus.class, datasetPermissions);
        this.taskRecordDataset = new DefaultORMDataset<TaskRecord>(TaskRecord.class, datasetPermissions);
    }

    public void refreshImage(Update update, Transaction<?> transaction) throws DatasetException {
        if (update != null && update.getUpdateStatus() != null && update.isImageTask()) {
            this.refresh(update.getUpdateStatus(), transaction);
        }
    }

    public Update queryByTaskId(UUID taskId, Transaction<?> transaction) throws DatasetException {
        ORMTransaction<?> ormTransaction = ORMTransaction.fromTransaction(transaction);
        Query query = ormTransaction.createQuery("select u from UpdateStatus u left join fetch u.taskRecord t left join fetch t.transaction left join fetch t.updateImage where u.taskId = :taskId").setParameter("taskId", (Object)taskId);
        UpdateStatus updateStatus = ormTransaction.querySingleRow(query, UpdateStatus.class);
        return new Update(updateStatus);
    }

    public UpdateImage queryImageByTaskId(UUID taskId, Transaction<?> transaction) throws DatasetException {
        ORMTransaction<?> ormTransaction = ORMTransaction.fromTransaction(transaction);
        Query query = ormTransaction.createQuery("select u.taskRecord.updateImage from UpdateStatus u where u.taskId = :taskId").setParameter("taskId", (Object)taskId);
        return ormTransaction.querySingleRow(query, UpdateImage.class);
    }

    public LabelId queryLabelIdForTaskId(UUID taskId, Transaction<?> transaction) throws DatasetException {
        Query query;
        ORMTransaction<?> ormTransaction = ORMTransaction.fromTransaction(transaction);
        Long result = ormTransaction.querySingleRow(query = ormTransaction.createQuery("select u.taskRecord.label from UpdateStatus u where u.taskId = :taskId").setParameter("taskId", (Object)taskId), Long.class);
        return result != null ? new LabelId(result.longValue()) : null;
    }

    public TransactionStatusInfo queryTransactionStatus(long transactionId, Transaction<?> transaction) throws DatasetException {
        DateTime startedTime;
        List results;
        TransactionRecord transactionRecord;
        ORMTransaction<?> ormTransaction = ORMTransaction.fromTransaction(transaction);
        try {
            Query transactionQuery = ormTransaction.createQuery("select t from TransactionRecord t where t.id = :id").setLong("id", transactionId);
            Query statusQuery = ormTransaction.createQuery("select u.status, u.retriesLeft, count(u), max(u.updatedAt), max(u.taskRecord.retryValidUntil) from UpdateStatus u where u.taskRecord.transaction.id = :id group by u.status, u.retriesLeft").setLong("id", transactionId);
            transactionRecord = (TransactionRecord)transactionQuery.uniqueResult();
            results = statusQuery.list();
            if (transactionRecord == null) {
                return null;
            }
        }
        catch (DatasetException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new DatasetException((Throwable)exc);
        }
        int totalUpdates = 0;
        int finishedUpdates = 0;
        int errorUpdates = 0;
        DateTime finishedTime = startedTime = transactionRecord.getCreatedAt();
        for (Object[] result : results) {
            Status status = (Status)result[0];
            int retriesLeft = (Integer)result[1];
            int count = ((Number)result[2]).intValue();
            DateTime updatedAt = (DateTime)result[3];
            DateTime retryValidUntil = (DateTime)result[4];
            if (status.isFinished()) {
                if (status.isSuccessful()) {
                    totalUpdates += count;
                    finishedUpdates += count;
                } else if ((status.isUnsuccessful() || status.isAborted()) && retriesLeft == 0 && (retryValidUntil == null || retryValidUntil.isBeforeNow())) {
                    totalUpdates += count;
                    finishedUpdates += count;
                    errorUpdates += count;
                }
            } else {
                totalUpdates += count;
            }
            if (finishedTime != null && !finishedTime.isBefore((ReadableInstant)updatedAt)) continue;
            finishedTime = updatedAt;
        }
        String title = transactionRecord.getTitle();
        int taskCount = transactionRecord.getTaskCount() != null ? transactionRecord.getTaskCount() : 0;
        long externalId = transactionRecord.getExternalId() != null ? transactionRecord.getExternalId() : 0L;
        return new TransactionStatusInfo(transactionId, title, taskCount, externalId, totalUpdates, finishedUpdates, errorUpdates, startedTime, finishedTime);
    }

    public void cleanupUpdateStatus(int daysToKeep, int maxCleanupRecords, int batchSize, Transaction<?> transaction) throws DatasetException {
        Calendar cleanupTime = Calendar.getInstance();
        cleanupTime.add(5, -daysToKeep);
        logger.info("Deleting update records with createdAt before %s", new Object[]{cleanupTime.getTime()});
        ORMTransaction<?> ormTransaction = ORMTransaction.fromTransaction(transaction);
        Query update = ormTransaction.createQuery("delete from UpdateStatus where createdAt < :cleanupTime and status in " + Status.FINISHED_SQL);
        update.setTimestamp("cleanupTime", cleanupTime.getTime());
        int deletedRows = ormTransaction.executeUpdate(update);
        logger.info("Deleted %d update status rows", new Object[]{deletedRows});
        logger.info("Deleting unreferenced tasks, transactions, images and label data");
        this.cleanupTaskRecords(batchSize, cleanupTime, maxCleanupRecords, false, ormTransaction);
        this.cleanupTransactions(batchSize, cleanupTime, maxCleanupRecords, false, ormTransaction);
        this.cleanupUpdateImages(batchSize, cleanupTime, maxCleanupRecords, ormTransaction);
    }

    public void cleanupArchiveTasks(int daysToKeep, int maxCleanupRecords, int batchSize, Transaction<?> transaction) throws DatasetException {
        Calendar cleanupTime = Calendar.getInstance();
        cleanupTime.add(5, -daysToKeep);
        logger.info("Deleting archive task records with createdAt before %s", new Object[]{cleanupTime.getTime()});
        ORMTransaction<?> ormTransaction = ORMTransaction.fromTransaction(transaction);
        Query update = ormTransaction.createQuery("delete from UpdateStatus where createdAt < :cleanupTime and internal = :internal");
        update.setTimestamp("cleanupTime", cleanupTime.getTime());
        update.setBoolean("internal", true);
        int deletedRows = ormTransaction.executeUpdate(update);
        logger.info("Deleted %d archive task rows", new Object[]{deletedRows});
        logger.info("Deleting unreferenced tasks, transactions and label data");
        this.cleanupTaskRecords(batchSize, cleanupTime, maxCleanupRecords, true, ormTransaction);
        this.cleanupTransactions(batchSize, cleanupTime, maxCleanupRecords, true, ormTransaction);
    }

    private void cleanupTaskRecords(int batchSize, Calendar cleanupTime, int maxCleanupRecords, boolean internal, ORMTransaction<?> transaction) throws DatasetException {
        Query query = transaction.createQuery("delete from TaskRecord where createdAt < :cleanupTime" + (internal ? " and internal = :internal" : ""));
        query.setTimestamp("cleanupTime", cleanupTime.getTime());
        if (internal) {
            query.setBoolean("internal", internal);
        }
        int deletedRows = transaction.executeUpdate(query);
        logger.info("Deleted %d task rows", new Object[]{deletedRows});
    }

    private void cleanupTransactions(int batchSize, Calendar cleanupTime, int maxCleanupRecords, boolean internal, ORMTransaction<?> transaction) throws DatasetException {
        Query query = transaction.createQuery("delete from TransactionRecord where createdAt < :cleanupTime" + (internal ? " and internal = :internal" : ""));
        query.setTimestamp("cleanupTime", cleanupTime.getTime());
        if (internal) {
            query.setBoolean("internal", internal);
        }
        int deletedRows = transaction.executeUpdate(query);
        logger.info("Deleted %d transaction rows", new Object[]{deletedRows});
    }

    private void cleanupUpdateImages(int batchSize, Calendar cleanupTime, int maxCleanupRecords, ORMTransaction<?> transaction) throws DatasetException {
        Query query = transaction.createQuery("delete from UpdateImage where createdAt < :cleanupTime or createdAt is null");
        query.setTimestamp("cleanupTime", cleanupTime.getTime());
        int deletedRows = transaction.executeUpdate(query);
        logger.info("Deleted %d image rows", new Object[]{deletedRows});
    }

    @Override
    public void store(Collection<UpdateStatus> records, UserId user, Transaction<?> transaction) throws DatasetException {
        this.persistTaskRecords(records, user, transaction);
        super.store(records, user, transaction);
    }

    private void persistTaskRecords(Collection<UpdateStatus> records, UserId user, Transaction<?> transaction) throws DatasetException {
        this.taskRecordDataset.store(Collections2.transform((Collection)Collections2.filter(records, (Predicate)new Predicate<UpdateStatus>(){

            public boolean apply(UpdateStatus updateStatus) {
                return updateStatus.getTaskRecord() != null && updateStatus.getTaskRecord().isNewRecord();
            }
        }), (Function)new Function<UpdateStatus, TaskRecord>(){

            public TaskRecord apply(UpdateStatus updateStatus) {
                return updateStatus.getTaskRecord();
            }
        }), user, transaction);
    }
}

