/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.dataset;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.record.AbstractDataset;
import at.mrdevelopment.esl.persistence.record.RequestHistoryRecord;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class RequestHistoryDataset
extends AbstractDataset<RequestHistoryRecord> {
    static ESLLogger logger = ESLLogger.getLogger(RequestHistoryDataset.class);
    private final SortedMap<Long, RequestHistoryRecord> records = new TreeMap<Long, RequestHistoryRecord>();

    public RequestHistoryDataset(Map<Role, DatasetPermissions> datasetPermissions) throws DatasetException, InitializationException {
        super(RequestHistoryRecord.class, datasetPermissions);
    }

    public RequestHistoryRecord queryById(long id, Transaction<?> transaction) throws DatasetException {
        return (RequestHistoryRecord)this.records.get(id);
    }

    public synchronized List<RequestHistoryRecord> queryAll(Transaction<?> transaction) throws DatasetException {
        return Collections.unmodifiableList(new ArrayList<RequestHistoryRecord>(this.records.values()));
    }

    public synchronized int getRecordCount(Transaction<?> transaction) {
        return this.records.size();
    }

    public synchronized void store(Collection<RequestHistoryRecord> records, UserId user, Transaction<?> transaction) {
        for (RequestHistoryRecord record : records) {
            if (this.records.size() >= Config.getApiRequestHistorySize()) {
                this.reduceHistorySize();
            }
            this.records.put(record.getId(), record);
        }
    }

    private void reduceHistorySize() {
        while (this.records.size() >= Config.getApiRequestHistorySize()) {
            this.records.remove(this.records.firstKey());
        }
    }

    public synchronized void delete(Collection<RequestHistoryRecord> records, UserId user, Transaction<?> transaction) {
        for (RequestHistoryRecord record : records) {
            this.records.remove(record.getId());
        }
    }

    public void close() {
    }
}

