/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.dataset;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.ORMDatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.query.QueryUrlRegistry;
import at.mrdevelopment.esl.persistence.record.AbstractDataset;
import at.mrdevelopment.esl.persistence.record.CommitState;
import at.mrdevelopment.esl.persistence.record.Commitable;
import at.mrdevelopment.esl.persistence.record.Record;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import at.mrdevelopment.esl.persistence.transaction.ReadUncommittedORMTransaction;
import at.mrdevelopment.esl.persistence.validator.RecordValidator;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public abstract class ORMDataset<T extends Record>
extends AbstractDataset<T> {
    static ESLLogger logger = ESLLogger.getLogger(ORMDataset.class);
    private final ORMDatasetQuery<T, Void> defaultQuery;
    private final List<RecordValidator<T>> validators = new ArrayList<RecordValidator<T>>();

    public ORMDataset(Class<T> recordClass, Map<Role, DatasetPermissions> datasetPermissions, List<String> customFields) throws InitializationException, DatasetException {
        super(recordClass, datasetPermissions, customFields);
        this.defaultQuery = new ORMDatasetQuery<T, Void>(this, QueryUrlRegistry.getDefaultQueryUrl(recordClass), Void.class){

            @Override
            protected Query getQuery(ORMTransaction<?> transaction, QueryRestriction<Void> queryRestriction) throws DatasetException {
                return transaction.createQuery("from " + this.getRecordClass().getName() + " t" + ORMDataset.this.getDefaultWhereClause() + ORMDataset.this.getDefaultOrderClause());
            }

            @Override
            protected Query getCountQuery(ORMTransaction<?> transaction, QueryRestriction<Void> queryRestriction) throws DatasetException {
                return transaction.createQuery("select count(*) from " + this.getRecordClass().getName() + " t" + ORMDataset.this.getDefaultWhereClause());
            }
        };
    }

    public void registerRecordValidator(RecordValidator<T> validator) {
        this.validators.add(validator);
    }

    public void unregisterRecordValidator(RecordValidator<T> validator) {
        this.validators.remove(validator);
    }

    public DatasetQuery<T, Void> getDefaultQuery() {
        return this.defaultQuery;
    }

    public T queryById(long id, Transaction<?> transaction) throws DatasetException {
        ORMTransaction<?> ormTransaction = ORMTransaction.fromTransaction(transaction);
        Query query = ormTransaction.createQuery("from " + this.getRecordClass().getName() + " t where t.id = :id").setLong("id", id);
        return (T)((Record)ormTransaction.querySingleRow(query, this.getRecordClass()));
    }

    public List<T> queryAll(Transaction<?> transaction) throws DatasetException {
        return this.defaultQuery.getResult((QueryRestriction<Void>)QueryRestriction.newUnpagedQuery(), transaction).getRecords();
    }

    public List<T> queryPage(int page, int recordsPerPage, Transaction<?> transaction) throws DatasetException {
        return this.defaultQuery.getResult((QueryRestriction<Void>)QueryRestriction.newPagedQuery((int)page, (int)recordsPerPage), transaction).getRecords();
    }

    public int getRecordCount(Transaction<?> transaction) throws DatasetException {
        ORMTransaction<?> ormTransaction = ORMTransaction.fromTransaction(transaction);
        Query query = ormTransaction.createQuery("select count(*) from " + this.getRecordClass().getName() + " t" + this.getDefaultWhereClause());
        return ormTransaction.queryCount(query);
    }

    public void store(Collection<T> records, UserId user, Transaction<?> transaction) throws DatasetException {
        ORMTransaction<?> ormTransaction = ORMTransaction.fromTransaction(transaction);
        try {
            for (Record record : records) {
                try {
                    for (RecordValidator<T> validator : this.validators) {
                        record.validate(validator);
                    }
                    if (record.isNewRecord()) {
                        this.checkInsertPermission(user.getRole());
                        this.doInsert(record, user, ormTransaction);
                        record.setCommitState(CommitState.INSERTED);
                        continue;
                    }
                    this.checkUpdatePermission(user.getRole());
                    this.doUpdate(record, user, ormTransaction);
                    record.setCommitState(CommitState.UPDATED);
                }
                catch (Exception exc) {
                    this.commitFail(record, exc);
                }
            }
        }
        catch (Exception exc) {
            throw new DatasetException((Throwable)exc);
        }
        if (!records.isEmpty()) {
            this.notifyRecordsModified(records, transaction);
        }
    }

    /*
     * Exception decompiling
     */
    public void delete(Collection<T> records, UserId user, Transaction<?> transaction) throws DatasetException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void refresh(T record, Transaction<?> transaction) throws DatasetException {
        if (record != null) {
            ORMTransaction<?> ormTransaction = ORMTransaction.fromTransaction(transaction);
            ormTransaction.refresh(record);
        }
    }

    public void clear(Transaction<?> transaction) throws DatasetException {
        ORMTransaction<?> ormTransaction = ORMTransaction.fromTransaction(transaction);
        ormTransaction.clear();
    }

    public void close() {
    }

    public static Transaction<?> newTransactionFromSessionFactory(SessionFactory sessionFactory) throws DatasetException {
        try {
            return new ORMTransaction((Session)sessionFactory.getCurrentSession());
        }
        catch (HibernateException exception) {
            throw new DatasetException((Throwable)exception);
        }
    }

    public static Transaction<?> newReadUncommittedTransactionFromSessionFactory(SessionFactory sessionFactory) throws DatasetException {
        try {
            return new ReadUncommittedORMTransaction((Session)sessionFactory.getCurrentSession());
        }
        catch (HibernateException exception) {
            throw new DatasetException((Throwable)exception);
        }
    }

    protected void doInsert(T record, UserId user, ORMTransaction<?> transaction) throws DatasetException {
        record.onCreate(user);
        this.notifyRecordInsert((Commitable)record, transaction);
        try {
            transaction.save(record);
        }
        catch (Exception exc) {
            throw new DatasetException((Throwable)exc);
        }
    }

    protected void doUpdate(T record, UserId user, ORMTransaction<?> transaction) throws DatasetException {
        record.onUpdate(user);
        this.notifyRecordUpdate((Commitable)record, transaction);
        try {
            transaction.saveOrUpdate(record);
        }
        catch (Exception exc) {
            throw new DatasetException((Throwable)exc);
        }
    }

    protected abstract void doDelete(T var1, UserId var2, ORMTransaction<?> var3) throws DatasetException;

    protected abstract String getDefaultWhereClause();

    protected String getDefaultOrderClause() {
        return " order by t.id";
    }

    private void commitFail(T record, Exception exc) {
        logger.warn("Failed to update record of type %s with ID %s: %s", new Object[]{record.getClass().getSimpleName(), record.getId(), exc.getMessage()});
        logger.logExceptionIfDebugEnabled((Throwable)exc);
        record.setCommitState(CommitState.FAILED);
        record.setCommitMessage(exc.getMessage());
    }
}

